/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.featurestemplating.expressions.aggregate;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.geoserver.featurestemplating.expressions.aggregate.AggregationOp;
import org.geotools.api.filter.capability.FunctionName;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.VolatileFunction;
import org.geotools.api.parameter.Parameter;
import org.geotools.filter.FunctionExpressionImpl;
import org.geotools.filter.capability.FunctionNameImpl;

public class SortFunction
extends FunctionExpressionImpl
implements VolatileFunction {
    private static FunctionName NAME = new FunctionNameImpl("sort", FunctionNameImpl.parameter((String)"result", Object.class), new Parameter[]{FunctionNameImpl.parameter((String)"order", String.class, (int)1, (int)1), FunctionNameImpl.parameter((String)"property", String.class, (int)0, (int)1)});

    public SortFunction() {
        super(NAME);
    }

    public Object evaluate(Object object) {
        Order order = this.getOrder();
        Expression pn = this.getPropertyName();
        return this.doSortNaturalOrder(object, order, pn);
    }

    private Order getOrder() {
        try {
            String strOrder = (String)((Expression)this.getParameters().get(0)).evaluate(null, String.class);
            return Order.valueOf(strOrder.trim().toUpperCase());
        }
        catch (EnumConstantNotPresentException e) {
            throw new RuntimeException("Error while parsing the Sort order in the Sort function. Valid sort oder are ASC, DESC");
        }
    }

    private Expression getPropertyName() {
        Expression result = null;
        List expressions = this.getParameters();
        if (expressions.size() > 1) {
            result = (Expression)expressions.get(1);
        }
        return result;
    }

    private List<Object> doSortNaturalOrder(Object object, Order order, Expression propertyName) {
        List<Object> objectList = object instanceof Collection ? new ArrayList((Collection)object) : (object instanceof Object[] ? Arrays.asList((Object[])object) : Arrays.asList(object));
        Comparator comparator = new ComparableOrToStringComparator(propertyName);
        if (order.equals((Object)Order.DESC)) {
            comparator = comparator.reversed();
        }
        objectList.sort(comparator);
        return objectList;
    }

    private static class ComparableOrToStringComparator
    implements Comparator {
        private Expression propertyName;

        ComparableOrToStringComparator(Expression pn) {
            this.propertyName = pn;
        }

        public int compare(Object o1, Object o2) {
            if (this.propertyName != null) {
                o1 = AggregationOp.unpack(this.propertyName.evaluate(o1));
                o2 = AggregationOp.unpack(this.propertyName.evaluate(o2));
            }
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            if (o1 instanceof Comparable && o2 instanceof Comparable) {
                int result = ((Comparable)o1).compareTo(o2);
                return result;
            }
            return o1.toString().compareTo(o2.toString());
        }
    }

    private static enum Order {
        ASC,
        DESC;

    }
}

