/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.featurestemplating.expressions.aggregate;

import java.util.List;
import java.util.logging.Logger;
import org.geoserver.featurestemplating.expressions.aggregate.AggregationOp;
import org.geotools.util.logging.Logging;

public abstract class MinMaxOp
extends AggregationOp {
    private static final Logger LOGGER = Logging.getLogger(MinMaxOp.class);

    MinMaxOp() {
        super(null);
    }

    @Override
    protected Object aggregateInternal(List<Object> values) {
        Number cur = this.initialValue();
        for (Object o : values) {
            Number otherN;
            if ((o = MinMaxOp.unpack(o)) != null && !Number.class.isAssignableFrom(o.getClass())) {
                String msg = "Cannot compute min or max value of a list where there are non numeric values.";
                LOGGER.severe(msg);
                throw new UnsupportedOperationException(msg);
            }
            if (o == null || !this.updateValue(cur, otherN = (Number)o)) continue;
            cur = otherN;
        }
        return cur;
    }

    protected abstract Number initialValue();

    protected abstract boolean updateValue(Number var1, Number var2);
}

