/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.featurestemplating.expressions.aggregate;

import java.util.List;
import java.util.logging.Logger;
import org.geoserver.featurestemplating.expressions.aggregate.AggregationOp;
import org.geotools.util.logging.Logging;

class AvgOp
extends AggregationOp {
    private static final Logger LOGGER = Logging.getLogger(AvgOp.class);

    AvgOp() {
        super(null);
    }

    @Override
    protected Object aggregateInternal(List<Object> list) {
        double sum = 0.0;
        for (int i = 0; i < list.size(); ++i) {
            Object o = list.get(i);
            if (!Number.class.isAssignableFrom((o = AvgOp.unpack(o)).getClass())) {
                String msg = "Cannot compute avg of a non numeric value";
                LOGGER.severe(msg);
                throw new UnsupportedOperationException(msg);
            }
            sum += ((Number)list.get(i)).doubleValue();
        }
        double avg = sum / (double)list.size();
        return avg;
    }
}

