/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.featurestemplating.expressions.aggregate;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.geoserver.featurestemplating.expressions.aggregate.AggregationOp;
import org.geoserver.featurestemplating.expressions.aggregate.AvgOp;
import org.geoserver.featurestemplating.expressions.aggregate.JoinOp;
import org.geoserver.featurestemplating.expressions.aggregate.MaxOp;
import org.geoserver.featurestemplating.expressions.aggregate.MinOp;
import org.geoserver.featurestemplating.expressions.aggregate.UniqueOp;
import org.geotools.util.logging.Logging;

class AggregateOpFactory {
    private static final Logger LOGGER = Logging.getLogger(AggregateOpFactory.class);

    AggregateOpFactory() {
    }

    static AggregationOp createOperation(String rawType) {
        String agName;
        int endNameIdx = rawType.indexOf("(");
        String param = null;
        if (endNameIdx != -1) {
            param = AggregateOpFactory.extractParam(rawType);
            agName = rawType.substring(0, endNameIdx).toUpperCase();
        } else {
            agName = rawType;
        }
        OpType opType = AggregateOpFactory.validateOpAndGet(agName);
        return AggregateOpFactory.getOp(opType, param);
    }

    private static AggregationOp getOp(OpType opType, String params) {
        AggregationOp op;
        switch (opType) {
            case AVG: {
                op = new AvgOp();
                break;
            }
            case MAX: {
                op = new MaxOp();
                break;
            }
            case MIN: {
                op = new MinOp();
                break;
            }
            case UNIQUE: {
                op = new UniqueOp();
                break;
            }
            default: {
                op = new JoinOp(params);
            }
        }
        return op;
    }

    private static OpType validateOpAndGet(String agName) {
        try {
            return OpType.valueOf(agName);
        }
        catch (EnumConstantNotPresentException e) {
            LOGGER.log(Level.SEVERE, "The aggregate type specified in the aggregate function was not recognized", e);
            throw new UnsupportedOperationException("The aggregate type specified in the aggregate function was not recognized");
        }
    }

    private static String extractParam(String aggregateValue) {
        StringBuilder sb = new StringBuilder("");
        char[] chars = aggregateValue.toCharArray();
        boolean startParam = false;
        for (char c : chars) {
            if (startParam && c != ')') {
                sb.append(c);
                continue;
            }
            if (c != '(') continue;
            startParam = true;
        }
        String value = sb.toString();
        if (StringUtils.isBlank((CharSequence)value)) {
            LOGGER.fine(() -> "No param found...");
            return null;
        }
        return value;
    }

    static enum OpType {
        JOIN,
        MIN,
        MAX,
        AVG,
        UNIQUE;

    }
}

