/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.featurestemplating.configuration;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.FilenameUtils;
import org.geoserver.featurestemplating.builders.impl.RootBuilder;
import org.geoserver.featurestemplating.readers.TemplateReader;
import org.geoserver.featurestemplating.readers.TemplateReaderConfiguration;
import org.geoserver.featurestemplating.readers.TemplateReaderProvider;
import org.geoserver.platform.FileWatcher;
import org.geoserver.platform.resource.Resource;

public class TemplateWatcher
extends FileWatcher<RootBuilder> {
    private TemplateReaderConfiguration configuration;

    public TemplateWatcher(Resource resource, TemplateReaderConfiguration configuration) {
        super(resource);
        this.configuration = configuration;
    }

    public RootBuilder read() throws IOException {
        RootBuilder result = null;
        if (this.resource.getType() == Resource.Type.RESOURCE) {
            try (InputStream is = this.resource.in();){
                result = this.parseResource(this.resource);
                this.lastModified = this.resource.lastmodified();
                this.lastCheck = System.currentTimeMillis();
                this.stale = false;
            }
        }
        return result;
    }

    public RootBuilder parseResource(Resource resource) throws IOException {
        String extension = FilenameUtils.getExtension((String)resource.name());
        TemplateReader reader = TemplateReaderProvider.findReader(extension, resource, this.configuration);
        return reader.getRootBuilder();
    }
}

