/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.featurestemplating.configuration;

import org.geoserver.featurestemplating.configuration.TemplateFileManager;
import org.geoserver.featurestemplating.configuration.TemplateInfo;
import org.geoserver.featurestemplating.configuration.TemplateInfoDAO;
import org.geoserver.featurestemplating.configuration.TemplateLoader;

public class TemplateService {
    private TemplateLoader loader = TemplateLoader.get();
    private TemplateFileManager templateFileManager = TemplateFileManager.get();
    private TemplateInfoDAO templateInfoDAO = TemplateInfoDAO.get();

    public void saveOrUpdate(TemplateInfo templateInfo, String rawTemplate) {
        this.templateFileManager.saveTemplateFile(templateInfo, rawTemplate);
        TemplateInfo current = this.templateInfoDAO.findById(templateInfo.getIdentifier());
        if (current != null && !current.getFullName().equals(templateInfo.getFullName()) && this.templateFileManager.delete(current)) {
            this.loader.removeAllWithIdentifier(templateInfo.getIdentifier());
        }
        this.templateInfoDAO.saveOrUpdate(templateInfo);
    }

    public void delete(TemplateInfo templateInfo) {
        this.templateFileManager.delete(templateInfo);
        this.loader.removeAllWithIdentifier(templateInfo.getIdentifier());
        this.templateInfoDAO.delete(templateInfo);
    }
}

