/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.featurestemplating.configuration;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.featurestemplating.configuration.TemplateLayerConfig;
import org.geoserver.featurestemplating.configuration.TemplateRule;
import org.geoserver.platform.GeoServerExtensions;

public class TemplateRuleService {
    private FeatureTypeInfo featureTypeInfo;

    public TemplateRuleService(FeatureTypeInfo featureTypeInfo) {
        this.featureTypeInfo = featureTypeInfo;
    }

    public boolean removeRule(String ruleId) {
        boolean result = false;
        Set<TemplateRule> rules = this.getRules();
        if (rules != null && !rules.isEmpty() && (result = rules.removeIf(r -> r.getRuleId().equals(ruleId)))) {
            TemplateLayerConfig config = this.getTemplateLayerConfig();
            config.setTemplateRules(rules);
            this.featureTypeInfo.getMetadata().put("FEATURES_TEMPLATING_LAYER_CONF", (Serializable)config);
            this.getCatalog().save((ResourceInfo)this.featureTypeInfo);
        }
        return result;
    }

    public void replaceRule(TemplateRule rule) {
        Set<TemplateRule> rules = this.getRules();
        if (rules != null && rules.removeIf(r -> r.getRuleId().equals(rule.getRuleId()))) {
            Set<TemplateRule> ruleset = TemplateRuleService.updatePriorities(new ArrayList<TemplateRule>(rules), rule);
            TemplateLayerConfig config = this.getTemplateLayerConfig();
            config.setTemplateRules(ruleset);
            this.featureTypeInfo.getMetadata().put("FEATURES_TEMPLATING_LAYER_CONF", (Serializable)config);
            this.getCatalog().save((ResourceInfo)this.featureTypeInfo);
        }
    }

    public void saveRule(TemplateRule rule) {
        TemplateLayerConfig config = this.getTemplateLayerConfig();
        if (config == null) {
            config = new TemplateLayerConfig();
        }
        Set<TemplateRule> rules = config.getTemplateRules();
        Set<TemplateRule> ruleset = TemplateRuleService.updatePriorities(new ArrayList<TemplateRule>(rules), rule);
        config.setTemplateRules(ruleset);
        this.featureTypeInfo.getMetadata().put("FEATURES_TEMPLATING_LAYER_CONF", (Serializable)config);
        this.getCatalog().save((ResourceInfo)this.featureTypeInfo);
    }

    private TemplateLayerConfig getTemplateLayerConfig() {
        return (TemplateLayerConfig)this.featureTypeInfo.getMetadata().get("FEATURES_TEMPLATING_LAYER_CONF", TemplateLayerConfig.class);
    }

    public Set<TemplateRule> getRules() {
        TemplateLayerConfig layerConfig = this.getTemplateLayerConfig();
        if (layerConfig != null) {
            return layerConfig.getTemplateRules();
        }
        return Collections.emptySet();
    }

    public TemplateRule getRule(String ruleId) {
        Optional<TemplateRule> opRule;
        Set<TemplateRule> rules = this.getRules();
        if (rules != null && !rules.isEmpty() && (opRule = rules.stream().filter(r -> r.getRuleId().equals(ruleId)).findFirst()).isPresent()) {
            return opRule.get();
        }
        return null;
    }

    private Catalog getCatalog() {
        return (Catalog)GeoServerExtensions.bean((String)"catalog");
    }

    public static Set<TemplateRule> updatePriorities(List<TemplateRule> rules, TemplateRule newRule) {
        HashSet<TemplateRule> set = new HashSet<TemplateRule>(rules.size());
        int updatedPriority = newRule.getPriority();
        boolean newRuleAdded = false;
        for (TemplateRule rule : rules) {
            boolean isUpdating = rule.getRuleId().equals(newRule.getRuleId());
            int priority = rule.getPriority();
            if (priority == updatedPriority) {
                if (!newRuleAdded) {
                    set.add(newRule);
                    newRuleAdded = true;
                }
                ++priority;
                if (!isUpdating) {
                    rule.setPriority(priority);
                    updatedPriority = priority;
                }
            }
            if (isUpdating) continue;
            set.add(rule);
        }
        if (set.isEmpty() || !newRuleAdded) {
            set.add(newRule);
        }
        return set;
    }
}

