/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.featurestemplating.configuration;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogException;
import org.geoserver.catalog.CatalogInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.catalog.event.CatalogAddEvent;
import org.geoserver.catalog.event.CatalogBeforeAddEvent;
import org.geoserver.catalog.event.CatalogListener;
import org.geoserver.catalog.event.CatalogModifyEvent;
import org.geoserver.catalog.event.CatalogPostModifyEvent;
import org.geoserver.catalog.event.CatalogRemoveEvent;
import org.geoserver.config.GeoServerDataDirectory;
import org.geoserver.featurestemplating.configuration.TemplateDAOListener;
import org.geoserver.featurestemplating.configuration.TemplateInfo;
import org.geoserver.featurestemplating.configuration.TemplateInfoDAO;
import org.geoserver.featurestemplating.configuration.TemplateInfoEvent;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.resource.Resource;
import org.geoserver.security.PropertyFileWatcher;

public class TemplateInfoDAOImpl
implements TemplateInfoDAO {
    private SortedSet<TemplateInfo> templateDataSet;
    private PropertyFileWatcher fileWatcher;
    private GeoServerDataDirectory dd;
    private Set<TemplateDAOListener> listeners;
    private static final String PROPERTY_FILE_NAME = "features-templates-data.properties";

    public TemplateInfoDAOImpl(GeoServerDataDirectory dd) {
        this.dd = dd;
        Resource templateDir = dd.get(new String[]{"features-templating"});
        File dir = templateDir.dir();
        if (!dir.exists()) {
            dir.mkdir();
        }
        Resource prop = dd.get(new String[]{"features-templating", PROPERTY_FILE_NAME});
        prop.file();
        this.fileWatcher = new PropertyFileWatcher(prop);
        this.templateDataSet = Collections.synchronizedSortedSet(new TreeSet());
        this.listeners = new HashSet<TemplateDAOListener>();
        Catalog catalog = (Catalog)GeoServerExtensions.bean((String)"catalog");
        catalog.addListener((CatalogListener)new CatalogListenerTemplateInfo());
    }

    @Override
    public List<TemplateInfo> findAll() {
        this.reloadIfNeeded();
        return new ArrayList<TemplateInfo>(this.templateDataSet);
    }

    @Override
    public TemplateInfo saveOrUpdate(TemplateInfo templateData) {
        this.reloadIfNeeded();
        boolean isUpdate = this.templateDataSet.stream().anyMatch(ti -> ti.getIdentifier().equals(templateData.getIdentifier()));
        if (isUpdate) {
            this.fireTemplateUpdateEvent(templateData);
            this.templateDataSet.removeIf(ti -> ti.getIdentifier().equals(templateData.getIdentifier()));
        }
        this.templateDataSet.add(templateData);
        this.storeProperties();
        return templateData;
    }

    @Override
    public void delete(TemplateInfo templateData) {
        this.reloadIfNeeded();
        this.templateDataSet.remove(templateData);
        this.fireTemplateInfoRemoveEvent(templateData);
        this.storeProperties();
    }

    @Override
    public void delete(List<TemplateInfo> templateInfos) {
        this.reloadIfNeeded();
        this.templateDataSet.removeAll(templateInfos);
        this.storeProperties();
        for (TemplateInfo ti : templateInfos) {
            this.fireTemplateInfoRemoveEvent(ti);
        }
    }

    @Override
    public void deleteAll() {
        this.reloadIfNeeded();
        SortedSet<TemplateInfo> templateInfos = this.templateDataSet;
        this.templateDataSet = Collections.synchronizedSortedSet(new TreeSet());
        this.storeProperties();
        for (TemplateInfo ti : templateInfos) {
            this.fireTemplateInfoRemoveEvent(ti);
        }
    }

    @Override
    public TemplateInfo findById(String id) {
        this.reloadIfNeeded();
        Optional<TemplateInfo> optional = this.templateDataSet.stream().filter(ti -> ti.getIdentifier().equals(id)).findFirst();
        if (optional.isPresent()) {
            return optional.get();
        }
        return null;
    }

    @Override
    public TemplateInfo findByFullName(String fullName) {
        this.reloadIfNeeded();
        Optional<TemplateInfo> templateInfo = this.templateDataSet.stream().filter(ti -> ti.getFullName().equals(fullName)).findFirst();
        if (templateInfo.isPresent()) {
            return templateInfo.get();
        }
        return null;
    }

    @Override
    public List<TemplateInfo> findByFeatureTypeInfo(FeatureTypeInfo featureTypeInfo) {
        this.reloadIfNeeded();
        String workspace = featureTypeInfo.getStore().getWorkspace().getName();
        String name = featureTypeInfo.getName();
        return this.templateDataSet.stream().filter(ti -> ti.getWorkspace() == null && ti.getFeatureType() == null || ti.getFeatureType() == null && ti.getWorkspace().equals(workspace) || ti.getWorkspace().equals(workspace) && ti.getFeatureType().equals(name)).collect(Collectors.toList());
    }

    private void fireTemplateUpdateEvent(TemplateInfo templateInfo) {
        for (TemplateDAOListener listener : this.listeners) {
            listener.handleUpdateEvent(new TemplateInfoEvent(templateInfo));
        }
    }

    private void fireTemplateInfoRemoveEvent(TemplateInfo templateInfo) {
        for (TemplateDAOListener listener : this.listeners) {
            listener.handleDeleteEvent(new TemplateInfoEvent(templateInfo));
        }
    }

    @Override
    public void addTemplateListener(TemplateDAOListener listener) {
        this.listeners.add(listener);
    }

    private TemplateInfo parseProperty(String key, String value) {
        String[] values;
        TemplateInfo templateData = new TemplateInfo();
        templateData.setIdentifier(key);
        for (String v : values = value.split(";")) {
            String[] attribute = v.split("=");
            String attrName = attribute[0];
            String attrValue = attribute[1];
            if (attrName.equals("templateName")) {
                templateData.setTemplateName(attrValue);
                continue;
            }
            if (attrName.equals("extension")) {
                templateData.setExtension(attrValue);
                continue;
            }
            if (attrName.equals("workspace")) {
                templateData.setWorkspace(attrValue);
                continue;
            }
            if (!attrName.equals("featureTypeInfo")) continue;
            templateData.setFeatureType(attrValue);
        }
        templateData.setIdentifier(key);
        return templateData;
    }

    private Properties toProperties() {
        Properties properties = new Properties();
        for (TemplateInfo td : this.templateDataSet) {
            String fti;
            StringBuilder sb = new StringBuilder();
            sb.append("templateName=").append(td.getTemplateName()).append(";extension=").append(td.getExtension());
            String ws = td.getWorkspace();
            if (ws != null) {
                sb.append(";workspace=").append(td.getWorkspace());
            }
            if ((fti = td.getFeatureType()) != null) {
                sb.append(";featureTypeInfo=").append(td.getFeatureType());
            }
            properties.put(td.getIdentifier(), sb.toString());
        }
        return properties;
    }

    public void storeProperties() {
        Properties p = this.toProperties();
        Resource propFile = this.dd.get(new String[]{"features-templating", PROPERTY_FILE_NAME});
        try (OutputStream os = propFile.out();){
            p.store(os, null);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not write rules to features-templates-data.properties");
        }
    }

    private boolean isModified() {
        return this.fileWatcher != null && this.fileWatcher.isStale();
    }

    private void loadTemplateInfo() {
        try {
            Properties properties = this.fileWatcher.getProperties();
            this.templateDataSet = Collections.synchronizedSortedSet(new TreeSet());
            for (Object k : properties.keySet()) {
                TemplateInfo td = this.parseProperty(k.toString(), properties.getProperty(k.toString()));
                this.templateDataSet.add(td);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void reloadIfNeeded() {
        if (this.isModified() || this.templateDataSet.isEmpty()) {
            this.loadTemplateInfo();
        }
    }

    public static class CatalogListenerTemplateInfo
    implements CatalogListener {
        public void handlePreAddEvent(CatalogBeforeAddEvent event) throws CatalogException {
        }

        public void handleAddEvent(CatalogAddEvent event) throws CatalogException {
        }

        public void handleRemoveEvent(CatalogRemoveEvent event) throws CatalogException {
            CatalogInfo source = event.getSource();
            if (source instanceof FeatureTypeInfo) {
                this.removeFtTemplates((FeatureTypeInfo)source);
            } else if (source instanceof WorkspaceInfo) {
                this.removeWSTemplates((WorkspaceInfo)source);
            }
        }

        private void removeFtTemplates(FeatureTypeInfo ft) {
            TemplateInfoDAOImpl dao = TemplateInfoDAO.get();
            List<TemplateInfo> templateInfos = dao.findByFeatureTypeInfo(ft);
            dao.delete(templateInfos.stream().filter(ti -> ti.getFeatureType() != null).collect(Collectors.toList()));
        }

        private void removeWSTemplates(WorkspaceInfo ws) {
            TemplateInfoDAOImpl dao = TemplateInfoDAO.get();
            List<TemplateInfo> templateInfos = dao.findAll().stream().filter(ti -> ti.getWorkspace().equals(ws.getName())).collect(Collectors.toList());
            dao.delete(templateInfos);
        }

        public void handleModifyEvent(CatalogModifyEvent event) throws CatalogException {
            int nameIdx;
            CatalogInfo source = event.getSource();
            if (source instanceof FeatureTypeInfo) {
                int nameIdx2 = event.getPropertyNames().indexOf("name");
                if (nameIdx2 != -1) {
                    String newName = (String)event.getNewValues().get(nameIdx2);
                    this.updateTemplateInfoLayerName((FeatureTypeInfo)source, newName);
                }
            } else if (source instanceof WorkspaceInfo && (nameIdx = event.getPropertyNames().indexOf("name")) != -1) {
                String oldName = (String)event.getOldValues().get(nameIdx);
                String newName = (String)event.getNewValues().get(nameIdx);
                this.updateWorkspaceNames(oldName, newName);
            }
        }

        private void updateTemplateInfoLayerName(FeatureTypeInfo fti, String newName) {
            TemplateInfoDAOImpl dao = TemplateInfoDAO.get();
            List<TemplateInfo> templateInfo = dao.findByFeatureTypeInfo(fti);
            for (TemplateInfo ti : templateInfo) {
                ti.setFeatureType(newName);
            }
            dao.storeProperties();
        }

        private void updateTemplateInfoWorkspace(WorkspaceInfo wi, FeatureTypeInfo fti) {
            TemplateInfoDAOImpl dao = TemplateInfoDAO.get();
            List<TemplateInfo> templateInfo = dao.findByFeatureTypeInfo(fti);
            for (TemplateInfo ti : templateInfo) {
                ti.setWorkspace(wi.getName());
            }
            dao.storeProperties();
        }

        private void updateWorkspaceNames(String oldName, String newName) {
            TemplateInfoDAOImpl dao = TemplateInfoDAO.get();
            List<TemplateInfo> infos = dao.findAll();
            for (TemplateInfo ti : infos) {
                if (!ti.getWorkspace().equals(oldName)) continue;
                ti.setWorkspace(newName);
            }
            dao.storeProperties();
        }

        public void handlePostModifyEvent(CatalogPostModifyEvent event) throws CatalogException {
            CatalogInfo source = event.getSource();
            if (source instanceof FeatureTypeInfo) {
                FeatureTypeInfo info = (FeatureTypeInfo)source;
                int wsIdx = event.getPropertyNames().indexOf("workspace");
                if (wsIdx != -1) {
                    WorkspaceInfo newWorkspace = (WorkspaceInfo)event.getNewValues().get(wsIdx);
                    this.updateTemplateInfoWorkspace(newWorkspace, info);
                }
            }
        }

        public void reloaded() {
        }
    }
}

