/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.featurestemplating.configuration;

import org.geoserver.ows.Dispatcher;
import org.geoserver.ows.Request;

public enum TemplateIdentifier {
    JSON("application/json", "geojson-template.json"),
    GEOJSON("application/geo+json", "geojson-template.json"),
    JSONLD("application/ld+json", "json-ld-template.json"),
    GML32("application/gml+xml;version=3.2", "gml32-template.xml"),
    GML31("gml3", "gml31-template.xml"),
    GML2("GML2text/xml;subtype=gml/2.1.2", "gml2-template.xml"),
    HTML("text/html", "html-template.xhtml");

    private String outputFormat;
    private String filename;

    private TemplateIdentifier(String outputFormat, String filename) {
        this.outputFormat = outputFormat;
        this.filename = filename;
    }

    public String getOutputFormat() {
        return this.outputFormat;
    }

    public String getFilename() {
        return this.filename;
    }

    public static TemplateIdentifier fromOutputFormat(String outputFormat) {
        TemplateIdentifier identifier = null;
        String trimOutputFormat = outputFormat.trim().replaceAll(" ", "");
        if (trimOutputFormat.equalsIgnoreCase(JSON.getOutputFormat())) {
            identifier = JSON;
        } else if (trimOutputFormat.equalsIgnoreCase(JSONLD.getOutputFormat())) {
            identifier = JSONLD;
        } else if (trimOutputFormat.equalsIgnoreCase(GEOJSON.getOutputFormat())) {
            identifier = GEOJSON;
        } else if (TemplateIdentifier.isGML32(trimOutputFormat)) {
            identifier = GML32;
        } else if (TemplateIdentifier.isGML31(trimOutputFormat)) {
            identifier = GML31;
        } else if (TemplateIdentifier.isGML2(trimOutputFormat)) {
            identifier = GML2;
        } else if (HTML.getOutputFormat().equals(trimOutputFormat)) {
            identifier = HTML;
        }
        return identifier;
    }

    private static boolean isGML2(String outputFormat) {
        Request request = (Request)Dispatcher.REQUEST.get();
        boolean isFeatureInfo = request != null && "GetFeatureInfo".equalsIgnoreCase(request.getRequest());
        boolean result = false;
        if (GML2.getOutputFormat().contains(outputFormat)) {
            result = true;
        } else if (isFeatureInfo && "text/xml".equals(outputFormat)) {
            result = true;
        }
        return result;
    }

    private static boolean isGML32(String outputFormat) {
        return GML32.getOutputFormat().contains(outputFormat);
    }

    private static boolean isGML31(String outputFormat) {
        return outputFormat.equalsIgnoreCase(GML31.getOutputFormat()) || outputFormat.equalsIgnoreCase("text/xml;subtype=gml/3.1.1") || outputFormat.equalsIgnoreCase("application/vnd.ogc.gml/3.1.1");
    }
}

