/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.featurestemplating.configuration;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.config.GeoServerDataDirectory;
import org.geoserver.featurestemplating.configuration.TemplateInfo;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.resource.Resource;

public class TemplateFileManager {
    private Catalog catalog;
    private GeoServerDataDirectory dd;

    public TemplateFileManager(Catalog catalog, GeoServerDataDirectory dd) {
        this.catalog = catalog;
        this.dd = dd;
    }

    public static TemplateFileManager get() {
        return (TemplateFileManager)GeoServerExtensions.bean(TemplateFileManager.class);
    }

    public Resource getTemplateResource(TemplateInfo templateInfo) {
        Resource resource;
        String featureType = templateInfo.getFeatureType();
        String workspace = templateInfo.getWorkspace();
        String templateName = templateInfo.getTemplateName();
        String extension = templateInfo.getExtension();
        if (featureType != null) {
            FeatureTypeInfo fti = this.catalog.getFeatureTypeByName(featureType);
            resource = this.dd.get((ResourceInfo)fti, new String[]{templateName + "." + extension});
        } else if (workspace != null) {
            WorkspaceInfo ws = this.catalog.getWorkspaceByName(workspace);
            resource = this.dd.get(ws, new String[]{templateName + "." + extension});
        } else {
            resource = this.dd.get(new String[]{"features-templating", templateName + "." + extension});
        }
        return resource;
    }

    public boolean delete(TemplateInfo templateInfo) {
        return this.getTemplateResource(templateInfo).delete();
    }

    public File getTemplateLocation(TemplateInfo templateInfo) {
        String featureType = templateInfo.getFeatureType();
        String workspace = templateInfo.getWorkspace();
        Resource resource = null;
        if (featureType != null) {
            FeatureTypeInfo fti = this.catalog.getFeatureTypeByName(featureType);
            resource = this.dd.get((ResourceInfo)fti, new String[0]);
        } else if (workspace != null) {
            WorkspaceInfo ws = this.catalog.getWorkspaceByName(workspace);
            resource = this.dd.get(ws, new String[0]);
        } else {
            resource = this.dd.get(new String[]{"features-templating"});
        }
        File destDir = resource.dir();
        if (!destDir.exists() || !destDir.isDirectory()) {
            destDir.mkdir();
        }
        return destDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveTemplateFile(TemplateInfo templateInfo, String rawTemplate) {
        File destDir = this.getTemplateLocation(templateInfo);
        try {
            File file = new File(destDir, templateInfo.getTemplateName() + "." + templateInfo.getExtension());
            if (!file.exists()) {
                file.createNewFile();
            }
            TemplateFileManager templateFileManager = this;
            synchronized (templateFileManager) {
                try (FileOutputStream fos = new FileOutputStream(file, false);){
                    fos.write(rawTemplate.getBytes());
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

