/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.featurestemplating.configuration;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.featurestemplating.builders.impl.RootBuilder;
import org.geoserver.featurestemplating.configuration.TemplateWatcher;
import org.geoserver.featurestemplating.readers.TemplateReaderConfiguration;
import org.geoserver.platform.FileWatcher;
import org.geoserver.platform.resource.Resource;
import org.geotools.util.logging.Logging;

public class Template {
    private Resource templateFile;
    private FileWatcher<RootBuilder> watcher;
    private RootBuilder builderTree;
    private static final Logger LOGGER = Logging.getLogger(Template.class);

    public Template(Resource templateFile, TemplateReaderConfiguration configuration) {
        this.templateFile = templateFile;
        this.watcher = new TemplateWatcher(templateFile, configuration);
        try {
            this.builderTree = (RootBuilder)this.watcher.read();
        }
        catch (IOException ioe) {
            throw new RuntimeException("Failure parsing " + templateFile, ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkTemplate() {
        if (this.needsReload()) {
            LOGGER.log(Level.INFO, "Reloading json-ld template for Feature Type {0}", this.templateFile.name());
            Template template = this;
            synchronized (template) {
                if (this.needsReload()) {
                    try {
                        RootBuilder root;
                        this.builderTree = root = (RootBuilder)this.watcher.read();
                        return true;
                    }
                    catch (IOException ioe) {
                        throw new RuntimeException(ioe);
                    }
                }
            }
        }
        return false;
    }

    private boolean needsReload() {
        return this.watcher != null && (this.watcher.isModified() || this.builderTree != null && this.builderTree.needsReload());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reloadTemplate() {
        Template template = this;
        synchronized (template) {
            if (this.watcher != null) {
                try {
                    RootBuilder root;
                    this.builderTree = root = (RootBuilder)this.watcher.read();
                }
                catch (IOException ioe) {
                    throw new RuntimeException(ioe);
                }
            }
        }
    }

    public RootBuilder getRootBuilder() {
        return this.builderTree;
    }
}

