/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.featurestemplating.configuration;

import java.io.Serializable;
import java.util.Optional;
import java.util.Set;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.featurestemplating.configuration.TemplateDAOListener;
import org.geoserver.featurestemplating.configuration.TemplateInfo;
import org.geoserver.featurestemplating.configuration.TemplateInfoEvent;
import org.geoserver.featurestemplating.configuration.TemplateLayerConfig;
import org.geoserver.featurestemplating.configuration.TemplateLoader;
import org.geoserver.featurestemplating.configuration.TemplateRule;
import org.geoserver.platform.GeoServerExtensions;

public class FeatureTypeTemplateDAOListener
implements TemplateDAOListener {
    private FeatureTypeInfo fti;

    public FeatureTypeTemplateDAOListener(FeatureTypeInfo featureTypeInfo) {
        this.fti = featureTypeInfo;
    }

    @Override
    public void handleDeleteEvent(TemplateInfoEvent deleteEvent) {
        Set<TemplateRule> rules;
        TemplateLayerConfig layerConfig = (TemplateLayerConfig)this.fti.getMetadata().get("FEATURES_TEMPLATING_LAYER_CONF", TemplateLayerConfig.class);
        TemplateInfo ti = deleteEvent.getSource();
        if (layerConfig != null && !(rules = layerConfig.getTemplateRules()).isEmpty() && rules.removeIf(r -> r.getTemplateIdentifier().equals(deleteEvent.getSource().getIdentifier()))) {
            this.fti.getMetadata().put("FEATURES_TEMPLATING_LAYER_CONF", (Serializable)layerConfig);
            this.saveFeatureTypeInfo();
            this.updateCache(ti);
        }
    }

    @Override
    public void handleUpdateEvent(TemplateInfoEvent updateEvent) {
        Set<TemplateRule> rules;
        TemplateLayerConfig layerConfig = (TemplateLayerConfig)this.fti.getMetadata().get("FEATURES_TEMPLATING_LAYER_CONF", TemplateLayerConfig.class);
        if (layerConfig != null && !(rules = layerConfig.getTemplateRules()).isEmpty()) {
            TemplateInfo info = updateEvent.getSource();
            Optional<TemplateRule> rule = rules.stream().filter(r -> r.getTemplateIdentifier().equals(info.getIdentifier())).findFirst();
            if (rule.isPresent()) {
                TemplateRule r2 = rule.get();
                if (!r2.getTemplateName().equals(info.getFullName())) {
                    r2.setTemplateName(info.getFullName());
                }
                this.updateCache(info);
                rules.removeIf(tr -> tr.getTemplateIdentifier().equals(info.getIdentifier()));
                rules.add(r2);
                layerConfig.setTemplateRules(rules);
                this.fti.getMetadata().put("FEATURES_TEMPLATING_LAYER_CONF", (Serializable)layerConfig);
                this.saveFeatureTypeInfo();
            }
        }
    }

    private void saveFeatureTypeInfo() {
        Catalog catalog = (Catalog)GeoServerExtensions.bean((String)"catalog");
        catalog.save((ResourceInfo)this.fti);
    }

    private void updateCache(TemplateInfo info) {
        TemplateLoader loader = TemplateLoader.get();
        loader.cleanCache(this.fti, info.getIdentifier());
    }
}

