/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.featurestemplating.builders.visitors;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import org.geoserver.featurestemplating.builders.AbstractTemplateBuilder;
import org.geoserver.featurestemplating.builders.TemplateBuilderUtils;
import org.geoserver.featurestemplating.builders.impl.TemplateBuilderContext;
import org.geoserver.featurestemplating.builders.selectionwrappers.PropertySelectionWrapper;
import org.geoserver.featurestemplating.builders.visitors.PropertySelectionContext;
import org.geoserver.featurestemplating.builders.visitors.PropertySelectionHandler;

public abstract class AbstractPropertySelection
implements PropertySelectionHandler {
    protected Set<String> includedFields;

    @Override
    public boolean isBuilderSelected(AbstractTemplateBuilder templateBuilder, Object context) {
        boolean result;
        TemplateBuilderContext builderContext = null;
        if (context != null) {
            builderContext = new TemplateBuilderContext(context);
        }
        if (templateBuilder instanceof PropertySelectionWrapper) {
            PropertySelectionWrapper selectionWrapper = (PropertySelectionWrapper)templateBuilder;
            String fullPath = selectionWrapper.getFullKey(builderContext);
            fullPath = this.removeDynamicMergeKey(fullPath);
            result = this.isKeySelected(fullPath);
        } else {
            result = this.isBuilderSelected(templateBuilder, null);
        }
        return result;
    }

    @Override
    public boolean isBuilderSelected(AbstractTemplateBuilder templateBuilder, PropertySelectionContext extradata) {
        String key = extradata != null ? extradata.getStaticFullKey() : templateBuilder.getKey(null);
        key = this.removeDynamicMergeKey(key);
        return this.isKeySelected(templateBuilder, key);
    }

    protected boolean isKeySelected(AbstractTemplateBuilder abstractTb, String key) {
        return TemplateBuilderUtils.hasSelectableKey(abstractTb) && this.isKeySelected(key) || key == null || !TemplateBuilderUtils.hasSelectableKey(abstractTb);
    }

    protected abstract boolean isKeySelected(String var1);

    @Override
    public JsonNode pruneJsonAttributes(JsonNode node, String fullKey) {
        if (node.isObject()) {
            this.pruneObjectNode((ObjectNode)node, fullKey);
        } else if (node.isArray()) {
            this.pruneArrayNode((ArrayNode)node, fullKey);
        }
        return node;
    }

    private void pruneArrayNode(ArrayNode arrayNode, String parentPath) {
        int length = arrayNode.size();
        for (int i = 0; i < length; ++i) {
            JsonNode node = arrayNode.get(i);
            if (!node.isObject()) continue;
            this.pruneObjectNode((ObjectNode)node, parentPath);
        }
    }

    private void pruneObjectNode(ObjectNode objectNode, String parentPath) {
        Iterator names = objectNode.fieldNames();
        ArrayList<String> excluded = new ArrayList<String>();
        while (names.hasNext()) {
            String name = (String)names.next();
            String fullPath = this.updatedFullKey(parentPath, name);
            if (!this.isKeySelected(fullPath = this.removeDynamicMergeKey(fullPath))) {
                excluded.add(name);
                continue;
            }
            JsonNode node = objectNode.get(name);
            if (this.emptyArrayOrObject(node)) {
                excluded.add(name);
                continue;
            }
            if (node.isObject()) {
                this.pruneObjectNode((ObjectNode)node, fullPath);
                continue;
            }
            if (!node.isArray()) continue;
            this.pruneArrayNode((ArrayNode)node, fullPath);
        }
        objectNode.remove(excluded);
    }

    private boolean emptyArrayOrObject(JsonNode node) {
        return (node.isArray() || node.isObject()) && node.isEmpty();
    }

    private String updatedFullKey(String currentPath, String attribute) {
        if (currentPath == null && attribute != null) {
            currentPath = attribute;
        } else if (attribute != null) {
            currentPath = currentPath.concat(".").concat(attribute);
        }
        return currentPath;
    }

    private String removeDynamicMergeKey(String key) {
        if (key != null) {
            int index = key.indexOf("$dynamicMerge_");
            while (index != -1) {
                String subStr = key.substring(index + "$dynamicMerge_".length());
                int sepIndex = subStr.indexOf(".");
                if (sepIndex == -1) {
                    key = null;
                    break;
                }
                String suffix = subStr.substring(0, sepIndex);
                key = key.replace("$dynamicMerge_" + suffix + ".", "");
                index = key.indexOf("$dynamicMerge_");
            }
        }
        return key;
    }
}

