/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.featurestemplating.builders.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.geoserver.featurestemplating.builders.EncodingHints;
import org.geoserver.featurestemplating.builders.TemplateBuilder;
import org.geoserver.featurestemplating.builders.VendorOptions;
import org.geoserver.featurestemplating.builders.flat.FlatBuilder;
import org.geoserver.featurestemplating.builders.impl.TemplateBuilderContext;
import org.geoserver.featurestemplating.builders.visitors.TemplateVisitor;
import org.geoserver.featurestemplating.expressions.TemplateCQLManager;
import org.geoserver.featurestemplating.writers.TemplateOutputWriter;
import org.geoserver.platform.FileWatcher;

public class RootBuilder
implements TemplateBuilder {
    private List<TemplateBuilder> children;
    private VendorOptions vendorOptions;
    private EncodingHints encodingHints;
    protected List<String> supportedOptions = new ArrayList<String>();
    private List<FileWatcher<Object>> watchers;

    public RootBuilder() {
        this.children = new ArrayList<TemplateBuilder>(2);
        this.vendorOptions = new VendorOptions();
    }

    @Override
    public void addChild(TemplateBuilder builder) {
        this.children.add(builder);
    }

    @Override
    public void evaluate(TemplateOutputWriter writer, TemplateBuilderContext context) throws IOException {
        for (TemplateBuilder jb : this.children) {
            jb.evaluate(writer, context);
        }
    }

    @Override
    public List<TemplateBuilder> getChildren() {
        return this.children;
    }

    public void setVendorOptions(String[] vendorOption) {
        TemplateCQLManager cqlManager = new TemplateCQLManager(vendorOption[1], null);
        this.vendorOptions.put(vendorOption[0], cqlManager.getExpressionFromString());
    }

    public void setVendorOptions(VendorOptions vendorOptions) {
        this.vendorOptions = vendorOptions;
    }

    public void addVendorOption(String name, Object value) {
        this.vendorOptions.put(name, value);
    }

    public void addVendorOptions(VendorOptions vendorOptions) {
        vendorOptions.putAll(vendorOptions);
    }

    public boolean needsReload() {
        TemplateBuilder aChild = this.getChildren().get(0);
        boolean isCachedFlattened = aChild instanceof FlatBuilder;
        boolean isFlatOutput = this.vendorOptions.get("flat_output", Boolean.class, false);
        if (isCachedFlattened && !isFlatOutput) {
            return true;
        }
        if (!isCachedFlattened && isFlatOutput) {
            return true;
        }
        if (this.watchers != null && !this.watchers.isEmpty()) {
            for (FileWatcher<Object> watcher : this.watchers) {
                if (!watcher.isModified()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void addEncodingHint(String key, Object value) {
        if (this.encodingHints == null) {
            this.encodingHints = new EncodingHints();
        }
        this.encodingHints.put(key, value);
    }

    public EncodingHints getEncodingHints() {
        if (this.encodingHints == null) {
            this.encodingHints = new EncodingHints();
        }
        return this.encodingHints;
    }

    public VendorOptions getVendorOptions() {
        return this.vendorOptions;
    }

    @Override
    public Object accept(TemplateVisitor visitor, Object value) {
        return visitor.visit(this, value);
    }

    public List<FileWatcher<Object>> getWatchers() {
        return this.watchers;
    }

    public void setWatchers(List<FileWatcher<Object>> watchers) {
        this.watchers = watchers;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RootBuilder that = (RootBuilder)o;
        return Objects.equals(this.children, that.children) && Objects.equals(this.vendorOptions, that.vendorOptions) && Objects.equals(this.encodingHints, that.encodingHints) && Objects.equals(this.supportedOptions, that.supportedOptions) && Objects.equals(this.watchers, that.watchers);
    }

    public int hashCode() {
        return Objects.hash(this.children, this.vendorOptions, this.encodingHints, this.supportedOptions, this.watchers);
    }
}

