/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.featurestemplating.builders.impl;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.featurestemplating.builders.AbstractTemplateBuilder;
import org.geoserver.featurestemplating.builders.EncodingHints;
import org.geoserver.featurestemplating.builders.JSONFieldSupport;
import org.geoserver.featurestemplating.builders.impl.TemplateBuilderContext;
import org.geoserver.featurestemplating.builders.visitors.TemplateVisitor;
import org.geoserver.featurestemplating.expressions.TemplateCQLManager;
import org.geoserver.featurestemplating.writers.TemplateOutputWriter;
import org.geotools.api.feature.Attribute;
import org.geotools.api.feature.ComplexAttribute;
import org.geotools.api.filter.expression.Expression;
import org.geotools.feature.ComplexAttributeImpl;
import org.geotools.filter.AttributeExpressionImpl;
import org.geotools.util.logging.Logging;
import org.xml.sax.helpers.NamespaceSupport;

public class DynamicValueBuilder
extends AbstractTemplateBuilder {
    protected Expression cql;
    protected AttributeExpressionImpl xpath;
    protected int contextPos = 0;
    private boolean encodeNull = false;
    private static final Logger LOGGER = Logging.getLogger(DynamicValueBuilder.class);

    public DynamicValueBuilder(String key, String expression, NamespaceSupport namespaces) {
        super(key, namespaces);
        if (expression.endsWith("!")) {
            this.encodeNull = true;
            expression = expression.substring(0, expression.length() - 1);
        }
        TemplateCQLManager cqlManager = new TemplateCQLManager(expression, namespaces);
        if (expression.startsWith("$${")) {
            this.cql = cqlManager.getExpressionFromString();
        } else if (expression.equals("${.}")) {
            this.cql = cqlManager.getThis();
        } else if (expression.startsWith("${")) {
            this.xpath = cqlManager.getAttributeExpressionFromString();
        } else {
            throw new IllegalArgumentException("Invalid value: " + expression);
        }
        this.contextPos = cqlManager.getContextPos();
    }

    public DynamicValueBuilder(DynamicValueBuilder dynamicBuilder, boolean includeChildren) {
        super(dynamicBuilder, includeChildren);
        this.cql = dynamicBuilder.getCql();
        this.xpath = dynamicBuilder.getXpath();
        this.encodeNull = dynamicBuilder.isEncodeNull();
        this.contextPos = dynamicBuilder.getContextPos();
    }

    @Override
    public void evaluate(TemplateOutputWriter writer, TemplateBuilderContext context) throws IOException {
        if (this.evaluateFilter(context)) {
            Object o = this.evaluateDirective(context);
            this.addChildrenEvaluationToEncodingHints(writer, context);
            this.writeValue(writer, o, context);
        }
    }

    protected void writeValue(TemplateOutputWriter writer, Object value, TemplateBuilderContext context) throws IOException {
        this.writeValue(null, writer, value, context);
    }

    protected void writeValue(String name, TemplateOutputWriter writer, Object value, TemplateBuilderContext context) throws IOException {
        if (this.encodeNull || this.canWriteValue(value)) {
            EncodingHints encodingHints = this.getEncodingHints();
            if (name == null) {
                name = this.getKey(context);
            }
            writer.writeElementNameAndValue(name, value, encodingHints);
        }
    }

    public Expression getCql() {
        return this.cql;
    }

    public AttributeExpressionImpl getXpath() {
        return this.xpath;
    }

    protected Object evaluateXPath(TemplateBuilderContext context) {
        for (int i = 0; i < this.contextPos; ++i) {
            context = context.getParent();
        }
        Object result = null;
        try {
            Object contextObject = this.getContextObject(context);
            result = this.xpath.evaluate(contextObject);
            result = JSONFieldSupport.parseWhenJSON((Expression)this.xpath, contextObject, result);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Unable to evaluate xpath " + this.xpath + ". Exception: {0}", e);
        }
        return result;
    }

    protected Object evaluateExpressions(Expression expression, TemplateBuilderContext context) {
        Object result = null;
        try {
            for (int i = 0; i < this.contextPos; ++i) {
                context = context.getParent();
            }
            Object contextObject = context.getCurrentObj();
            result = expression.evaluate(contextObject);
            result = JSONFieldSupport.parseWhenJSON(this.cql, contextObject, result);
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, "Unable to evaluate expression. Exception: {0}", e.getMessage());
        }
        return result;
    }

    protected boolean canWriteValue(Object value) {
        if (value instanceof ComplexAttributeImpl) {
            return this.canWriteValue(((ComplexAttribute)value).getValue());
        }
        if (value instanceof Attribute) {
            return this.canWriteValue(((Attribute)value).getValue());
        }
        if (value instanceof List && ((List)value).size() == 0) {
            return ((List)value).size() != 0;
        }
        return value != null && !value.equals("null") && !"".equals(value);
    }

    public int getContextPos() {
        return this.contextPos;
    }

    @Override
    public boolean canWrite(TemplateBuilderContext context) {
        if (this.encodeNull) {
            return true;
        }
        Object o = null;
        if (this.xpath != null) {
            o = this.evaluateXPath(context);
        } else if (this.cql != null) {
            o = this.evaluateExpressions(this.cql, context);
        }
        return o != null;
    }

    public void setCql(Expression cql) {
        this.cql = cql;
    }

    public void setXpath(AttributeExpressionImpl xpath) {
        this.xpath = xpath;
    }

    @Override
    public Object accept(TemplateVisitor visitor, Object value) {
        return visitor.visit(this, value);
    }

    protected Object getContextObject(TemplateBuilderContext context) {
        List multipleValue;
        Object contextObject = context.getCurrentObj();
        if (contextObject != null && contextObject instanceof List && !(multipleValue = (List)contextObject).isEmpty()) {
            contextObject = multipleValue.get(0);
        }
        return contextObject;
    }

    protected boolean hasDynamic(JsonNode node) {
        return node.toString().contains("$");
    }

    public boolean isEncodeNull() {
        return this.encodeNull;
    }

    @Override
    public DynamicValueBuilder copy(boolean includeChildren) {
        return new DynamicValueBuilder(this, includeChildren);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.cql, this.xpath, this.contextPos, this.namespaces, this.encodeNull);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DynamicValueBuilder that = (DynamicValueBuilder)o;
        return this.contextPos == that.contextPos && this.encodeNull == that.encodeNull && Objects.equals(this.cql, that.cql) && Objects.equals(this.xpath, that.xpath) && Objects.equals(this.namespaces, that.namespaces);
    }

    protected Object evaluateDirective(TemplateBuilderContext context) {
        Object evaluate = null;
        if (this.xpath != null) {
            evaluate = this.evaluateXPath(context);
        } else if (this.cql != null) {
            evaluate = this.evaluateExpressions(this.cql, context);
        }
        return evaluate;
    }
}

