/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.featurestemplating.builders.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.Objects;
import java.util.logging.Logger;
import org.geoserver.featurestemplating.builders.TemplateBuilder;
import org.geoserver.featurestemplating.builders.impl.DynamicJsonBuilder;
import org.geoserver.featurestemplating.builders.impl.TemplateBuilderContext;
import org.geoserver.featurestemplating.readers.JSONMerger;
import org.geoserver.featurestemplating.writers.TemplateOutputWriter;
import org.geotools.util.logging.Logging;
import org.xml.sax.helpers.NamespaceSupport;

public class DynamicMergeBuilder
extends DynamicJsonBuilder {
    private static final Logger LOGGER = Logging.getLogger(DynamicMergeBuilder.class);
    private boolean overlayExpression;

    public DynamicMergeBuilder(String key, String expression, NamespaceSupport namespaces, JsonNode node, boolean overlayExpression) {
        super(key, expression, namespaces, node);
        this.overlayExpression = overlayExpression;
    }

    public DynamicMergeBuilder(DynamicMergeBuilder original, boolean includeChildren) {
        super(original, includeChildren);
        this.overlayExpression = original.overlayExpression;
    }

    @Override
    protected boolean canWriteValue(Object value) {
        if (this.overlayExpression) {
            return super.canWriteValue(value);
        }
        return this.node != null;
    }

    @Override
    public boolean canWrite(TemplateBuilderContext context) {
        if (this.overlayExpression) {
            return super.canWrite(context);
        }
        return this.node != null;
    }

    @Override
    public void evaluate(TemplateOutputWriter writer, TemplateBuilderContext context) throws IOException {
        Object evaluate = this.evaluateDirective(context);
        if (!(evaluate instanceof JsonNode)) {
            if (this.overlayExpression) {
                this.addChildrenEvaluationToEncodingHints(writer, context);
                this.writeValue(writer, evaluate, context);
            } else if (this.hasDynamic(this.node)) {
                this.writeFromNestedTree(context, writer, this.node);
            } else {
                this.writeValue(writer, this.node, context);
            }
        } else {
            JSONMerger jsonMerger = new JSONMerger();
            JsonNode attrNode = (JsonNode)evaluate;
            this.validateJson(attrNode);
            ObjectNode mergedNodes = this.overlayExpression ? jsonMerger.mergeTrees(this.node, attrNode) : jsonMerger.mergeTrees(attrNode, this.node);
            if (this.hasDynamic((JsonNode)mergedNodes)) {
                this.writeFromNestedTree(context, writer, (JsonNode)mergedNodes);
            } else {
                this.writeValue(writer, mergedNodes, context);
            }
        }
    }

    protected void writeFromNestedTree(TemplateBuilderContext context, TemplateOutputWriter writer, JsonNode node) throws IOException {
        writer.startObject(this.getKey(context), this.getEncodingHints());
        super.iterateAndEvaluateNestedTree(context, writer, node);
        writer.endObject(this.getKey(context), this.encodingHints);
    }

    @Override
    public TemplateBuilder getNestedTree(JsonNode node, TemplateBuilderContext context) {
        return this.getNestedTree(node, context, true);
    }

    @Override
    public DynamicMergeBuilder copy(boolean includeChildren) {
        return new DynamicMergeBuilder(this, includeChildren);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DynamicMergeBuilder that = (DynamicMergeBuilder)o;
        return this.overlayExpression == that.overlayExpression;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.overlayExpression);
    }
}

