/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.featurestemplating.builders.impl;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.geoserver.featurestemplating.builders.TemplateBuilder;
import org.geoserver.featurestemplating.builders.TemplateBuilderMaker;
import org.geoserver.featurestemplating.builders.impl.CompositeBuilder;
import org.geoserver.featurestemplating.builders.impl.DynamicValueBuilder;
import org.geoserver.featurestemplating.builders.impl.TemplateBuilderContext;
import org.geoserver.featurestemplating.readers.JSONTemplateReader;
import org.geoserver.featurestemplating.readers.TemplateReaderConfiguration;
import org.geoserver.featurestemplating.writers.TemplateOutputWriter;
import org.geoserver.platform.FileWatcher;
import org.xml.sax.helpers.NamespaceSupport;

public abstract class DynamicJsonBuilder
extends DynamicValueBuilder {
    protected JsonNode node;

    protected DynamicJsonBuilder(String key, String expression, NamespaceSupport namespaces, JsonNode node) {
        super(key, expression, namespaces);
        this.node = node;
    }

    protected DynamicJsonBuilder(DynamicJsonBuilder original, boolean includeChildren) {
        super(original, includeChildren);
        if (original.node != null) {
            this.node = original.node.deepCopy();
        }
    }

    protected void iterateAndEvaluateNestedTree(TemplateBuilderContext context, TemplateOutputWriter writer, JsonNode node) throws IOException {
        TemplateBuilder builder = this.getNestedTree(node, context);
        List<TemplateBuilder> children = builder.getChildren();
        if (!children.isEmpty()) {
            for (TemplateBuilder child : children) {
                child.evaluate(writer, context);
            }
        }
    }

    public abstract TemplateBuilder getNestedTree(JsonNode var1, TemplateBuilderContext var2);

    protected TemplateBuilder getNestedTree(JsonNode node, TemplateBuilderContext context, boolean topLevelComplex) {
        TemplateReaderConfiguration configuration = new TemplateReaderConfiguration(this.getNamespaces());
        JSONTemplateReader jsonTemplateReader = new JSONTemplateReader(node, configuration, new ArrayList<FileWatcher<Object>>());
        TemplateBuilderMaker maker = configuration.getBuilderMaker();
        maker.namespaces(configuration.getNamespaces());
        String key = this.getKey(context);
        CompositeBuilder cb = new CompositeBuilder(key, this.getNamespaces(), topLevelComplex);
        jsonTemplateReader.getBuilderFromJson(key, node, cb, maker);
        return cb;
    }

    protected JsonNode getJsonNodeAttributeValue(TemplateBuilderContext context) {
        Object evaluate = this.evaluateDirective(context);
        JsonNode result = null;
        if (evaluate != null) {
            if (!(evaluate instanceof JsonNode)) {
                throw new UnsupportedOperationException("The selected attribute is not a JSON");
            }
            result = (JsonNode)evaluate;
            this.validateJson(result);
        }
        return result;
    }

    protected void validateJson(JsonNode node) {
        if (node.toString().contains("${")) {
            throw new UnsupportedOperationException("A json attribute value cannot have a template directive among its fields.");
        }
    }

    public JsonNode getNode() {
        return this.node;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DynamicJsonBuilder that = (DynamicJsonBuilder)o;
        return Objects.equals(this.node, that.node);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.node);
    }
}

