/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.featurestemplating.builders.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Logger;
import org.geoserver.featurestemplating.builders.JSONFieldSupport;
import org.geoserver.featurestemplating.builders.TemplateBuilder;
import org.geoserver.featurestemplating.builders.TemplateBuilderMaker;
import org.geoserver.featurestemplating.builders.impl.CompositeBuilder;
import org.geoserver.featurestemplating.builders.impl.DynamicJsonBuilder;
import org.geoserver.featurestemplating.builders.impl.TemplateBuilderContext;
import org.geoserver.featurestemplating.readers.JSONMerger;
import org.geoserver.featurestemplating.readers.JSONTemplateReader;
import org.geoserver.featurestemplating.readers.TemplateReaderConfiguration;
import org.geoserver.featurestemplating.writers.TemplateOutputWriter;
import org.geoserver.platform.FileWatcher;
import org.geotools.api.feature.Attribute;
import org.geotools.api.feature.Feature;
import org.geotools.util.logging.Logging;
import org.xml.sax.helpers.NamespaceSupport;

public class DynamicIncludeFlatBuilder
extends DynamicJsonBuilder {
    private static Logger LOGGER = Logging.getLogger(DynamicIncludeFlatBuilder.class);

    public DynamicIncludeFlatBuilder(String expression, NamespaceSupport namespaces, JsonNode node) {
        super(null, expression, namespaces, node);
    }

    public DynamicIncludeFlatBuilder(DynamicIncludeFlatBuilder original, boolean includeChildren) {
        super(original, includeChildren);
    }

    @Override
    public void evaluate(TemplateOutputWriter writer, TemplateBuilderContext context) throws IOException {
        if (this.canWrite(context)) {
            ObjectNode finalNode = this.getFinalJSON(context);
            if (finalNode != null) {
                this.doIncludeFlat(finalNode, context, writer);
            } else {
                this.iterateAndEvaluateNestedTree(context, writer, this.node);
            }
        }
    }

    protected ObjectNode getFinalJSON(TemplateBuilderContext context) {
        JsonNode node = this.getJsonNodeAttributeValue(context);
        return this.mergeNodes(node);
    }

    private ObjectNode mergeNodes(JsonNode evaluate) {
        ObjectNode finalNode = null;
        if (!(evaluate instanceof ObjectNode) && evaluate != null) {
            String message = "Cannot include flat a value different from a JSON object";
            LOGGER.severe(() -> message);
            throw new UnsupportedOperationException(message);
        }
        if (evaluate != null) {
            JSONMerger merger = new JSONMerger();
            finalNode = merger.mergeTrees(this.node, (JsonNode)((ObjectNode)evaluate));
        }
        return finalNode;
    }

    private void doIncludeFlat(ObjectNode finalNode, TemplateBuilderContext context, TemplateOutputWriter writer) throws IOException {
        if (this.hasDynamic((JsonNode)finalNode)) {
            LOGGER.fine(() -> "Included Json object has property interpolation or expression.Going to build a nested TemplateBuilder tree.");
            this.iterateAndEvaluateNestedTree(context, writer, (JsonNode)finalNode);
        } else {
            LOGGER.fine(() -> "Writing the included flat Json Node.");
            this.iterateAndWrite(finalNode, writer, context);
        }
    }

    protected void iterateAndWrite(ObjectNode objectNode, TemplateOutputWriter writer, TemplateBuilderContext context) throws IOException {
        Iterator names = objectNode.fieldNames();
        while (names != null && names.hasNext()) {
            String name = (String)names.next();
            this.writeValue(name, writer, objectNode.findValue(name), context);
        }
    }

    @Override
    protected boolean canWriteValue(Object value) {
        return this.node != null;
    }

    @Override
    public boolean canWrite(TemplateBuilderContext context) {
        return this.node != null;
    }

    public TemplateBuilder getIncludeFlatBuilder(String key, Feature sample) {
        if (sample == null) {
            return null;
        }
        Object evaluate = null;
        if (this.xpath != null) {
            evaluate = this.xpath.evaluate((Object)sample);
        } else if (this.cql != null) {
            evaluate = this.cql.evaluate((Object)sample);
        }
        if (evaluate instanceof Attribute) {
            evaluate = JSONFieldSupport.parseWhenJSON(null, null, evaluate);
        }
        if (!(evaluate instanceof JsonNode)) {
            return null;
        }
        return this.getBuilderFromNode(key, (JsonNode)evaluate);
    }

    private TemplateBuilder getBuilderFromNode(String key, JsonNode node) {
        TemplateReaderConfiguration configuration = new TemplateReaderConfiguration(this.getNamespaces());
        TemplateBuilderMaker maker = configuration.getBuilderMaker();
        maker.namespaces(configuration.getNamespaces());
        JSONTemplateReader jsonTemplateReader = new JSONTemplateReader(node, configuration, new ArrayList<FileWatcher<Object>>());
        CompositeBuilder result = new CompositeBuilder(key, this.getNamespaces(), false);
        jsonTemplateReader.getBuilderFromJson(null, node, result, maker);
        return result;
    }

    public TemplateBuilder getIncludingNodeBuilder(String key) {
        if (!this.node.isObject()) {
            return null;
        }
        return this.getBuilderFromNode(key, this.node);
    }

    @Override
    public TemplateBuilder getNestedTree(JsonNode node, TemplateBuilderContext context) {
        return this.getNestedTree(node, context, false);
    }

    @Override
    public DynamicIncludeFlatBuilder copy(boolean includeChildren) {
        return new DynamicIncludeFlatBuilder(this, includeChildren);
    }
}

