/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.featurestemplating.builders.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import java.io.IOException;
import java.util.logging.Logger;
import org.geoserver.featurestemplating.builders.TemplateBuilder;
import org.geoserver.featurestemplating.builders.impl.DynamicIncludeFlatBuilder;
import org.geoserver.featurestemplating.builders.impl.DynamicJsonBuilder;
import org.geoserver.featurestemplating.builders.impl.DynamicValueBuilder;
import org.geoserver.featurestemplating.builders.impl.TemplateBuilderContext;
import org.geoserver.featurestemplating.writers.TemplateOutputWriter;
import org.geotools.util.logging.Logging;
import org.xml.sax.helpers.NamespaceSupport;

public class ArrayIncludeFlatBuilder
extends DynamicJsonBuilder {
    private static Logger LOGGER = Logging.getLogger(DynamicIncludeFlatBuilder.class);

    public ArrayIncludeFlatBuilder(String key, String expression, NamespaceSupport namespaces, JsonNode node) {
        super(key, expression, namespaces, node);
    }

    public ArrayIncludeFlatBuilder(DynamicJsonBuilder original, boolean includeChildren) {
        super(original, includeChildren);
    }

    @Override
    public void evaluate(TemplateOutputWriter writer, TemplateBuilderContext context) throws IOException {
        if (this.canWrite(context)) {
            ArrayNode finalNode = this.getFinalJSON(context);
            if (finalNode != null) {
                this.doIncludeFlat(finalNode, context, writer);
            } else {
                this.iterateAndEvaluateNestedTree(context, writer, this.node);
            }
        }
    }

    protected ArrayNode getFinalJSON(TemplateBuilderContext context) {
        return this.mergeNodes(context);
    }

    private ArrayNode mergeNodes(TemplateBuilderContext context) {
        JsonNodeFactory factory = JsonNodeFactory.instance;
        ArrayNode finalNode = factory.arrayNode();
        for (TemplateBuilder builder : this.getChildren()) {
            DynamicValueBuilder dynamicBuilder = (DynamicValueBuilder)builder;
            Object evaluate = dynamicBuilder.evaluateDirective(context);
            if (!(evaluate instanceof ArrayNode) && evaluate != null) {
                String message = "Cannot include flat a value different from a JSON Array into the containing array";
                LOGGER.severe(() -> message);
                throw new UnsupportedOperationException(message);
            }
            if (evaluate != null) {
                ArrayNode arrayNode = (ArrayNode)evaluate;
                finalNode.addAll(arrayNode);
                continue;
            }
            if (evaluate != null || !dynamicBuilder.isEncodeNull()) continue;
            finalNode.add((JsonNode)factory.nullNode());
        }
        finalNode.addAll((ArrayNode)this.node);
        return finalNode;
    }

    private void doIncludeFlat(ArrayNode finalNode, TemplateBuilderContext context, TemplateOutputWriter writer) throws IOException {
        if (this.hasDynamic((JsonNode)finalNode)) {
            LOGGER.fine(() -> "Included Json object has property interpolation or expression.Going to build a nested TemplateBuilder tree.");
            this.iterateAndEvaluateNestedTree(context, writer, (JsonNode)finalNode);
        } else {
            LOGGER.fine(() -> "Writing the included flat Json Node.");
            this.iterateAndWrite(finalNode, writer, context);
        }
    }

    protected void iterateAndWrite(ArrayNode arrayResult, TemplateOutputWriter writer, TemplateBuilderContext context) throws IOException {
        String key = this.getKey(context);
        writer.writeElementNameAndValue(key, arrayResult, this.getEncodingHints());
    }

    @Override
    protected boolean canWriteValue(Object value) {
        return this.node != null;
    }

    @Override
    public boolean canWrite(TemplateBuilderContext context) {
        return this.node != null;
    }

    @Override
    public TemplateBuilder getNestedTree(JsonNode node, TemplateBuilderContext context) {
        return this.getNestedTree(node, context, false);
    }

    @Override
    public ArrayIncludeFlatBuilder copy(boolean includeChildren) {
        return new ArrayIncludeFlatBuilder(this, includeChildren);
    }
}

