/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.featurestemplating.builders.flat;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import org.geoserver.featurestemplating.builders.flat.AttributeNameHelper;
import org.geoserver.featurestemplating.builders.flat.FlatBuilder;
import org.geoserver.featurestemplating.builders.impl.StaticBuilder;
import org.geoserver.featurestemplating.builders.impl.TemplateBuilderContext;
import org.geoserver.featurestemplating.writers.GeoJSONWriter;
import org.geoserver.featurestemplating.writers.TemplateOutputWriter;
import org.xml.sax.helpers.NamespaceSupport;

public class FlatStaticBuilder
extends StaticBuilder
implements FlatBuilder {
    private AttributeNameHelper nameHelper;

    public FlatStaticBuilder(String key, JsonNode value, NamespaceSupport namespaces, String separator) {
        super(key, value, namespaces);
        this.nameHelper = new AttributeNameHelper(this.key, separator);
    }

    public FlatStaticBuilder(String key, String strValue, NamespaceSupport namespaces, String separator) {
        super(key, strValue, namespaces);
        this.nameHelper = new AttributeNameHelper(this.key, separator);
    }

    public FlatStaticBuilder(FlatStaticBuilder builder, boolean includeChildren) {
        super(builder, includeChildren);
        this.nameHelper = new AttributeNameHelper(this.key, builder.nameHelper.getSeparator());
    }

    @Override
    protected void evaluateInternal(TemplateOutputWriter writer, TemplateBuilderContext context) throws IOException {
        GeoJSONWriter geoJsonWriter = (GeoJSONWriter)writer;
        if (this.strValue != null) {
            geoJsonWriter.writeStaticContent(this.nameHelper.getFinalAttributeName(context), (Object)this.strValue, this.nameHelper.getSeparator());
        } else {
            geoJsonWriter.writeStaticContent(this.nameHelper.getFinalAttributeName(context), (Object)this.staticValue, this.nameHelper.getSeparator());
        }
    }

    @Override
    public void setParentKey(String parentKey) {
        this.nameHelper.setParentKey(parentKey);
    }

    @Override
    public FlatStaticBuilder copy(boolean includeChildren) {
        return new FlatStaticBuilder(this, includeChildren);
    }
}

