/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.featurestemplating.builders;

import org.geoserver.featurestemplating.builders.AbstractTemplateBuilder;
import org.geoserver.featurestemplating.builders.SourceBuilder;
import org.geoserver.featurestemplating.builders.TemplateBuilder;
import org.geoserver.featurestemplating.builders.impl.CompositeBuilder;

public class TemplateBuilderUtils {
    public static boolean hasSelectableKey(TemplateBuilder builder) {
        boolean validKey = true;
        if (builder instanceof SourceBuilder) {
            SourceBuilder sourceBuilder = (SourceBuilder)builder;
            validKey = !sourceBuilder.isTopLevelFeature() && sourceBuilder.hasOwnOutput();
        }
        return validKey;
    }

    public static TemplateBuilder getBuilderFor(TemplateBuilder builder, String ... pathComponents) {
        for (String path : pathComponents) {
            if ((builder = TemplateBuilderUtils.lookupBuilder(builder, path)) != null) continue;
            return null;
        }
        return builder;
    }

    private static AbstractTemplateBuilder lookupBuilder(TemplateBuilder parent, String key) {
        for (TemplateBuilder child : parent.getChildren()) {
            if (!(child instanceof AbstractTemplateBuilder)) continue;
            AbstractTemplateBuilder atb = (AbstractTemplateBuilder)child;
            if (key.equals(atb.getKey(null))) {
                return atb;
            }
            if (!(atb instanceof CompositeBuilder) || atb.getKey(null) != null) continue;
            return TemplateBuilderUtils.lookupBuilder(atb, key);
        }
        return null;
    }
}

