/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.featurestemplating.builders;

import java.util.LinkedList;
import java.util.Objects;
import java.util.Optional;
import org.geoserver.featurestemplating.builders.AbstractTemplateBuilder;
import org.geoserver.featurestemplating.builders.impl.TemplateBuilderContext;
import org.geoserver.featurestemplating.expressions.TemplateCQLManager;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.Literal;
import org.geotools.filter.AttributeExpressionImpl;
import org.xml.sax.helpers.NamespaceSupport;

public abstract class SourceBuilder
extends AbstractTemplateBuilder {
    private Expression source;
    protected boolean ownOutput = true;
    protected boolean topLevelFeature;

    public SourceBuilder(String key, NamespaceSupport namespaces, boolean topLevelFeature) {
        super(key, namespaces);
        this.children = new LinkedList();
        this.topLevelFeature = topLevelFeature;
    }

    protected SourceBuilder(SourceBuilder sourceBuilder, boolean includeChildren) {
        super(sourceBuilder, includeChildren);
        this.topLevelFeature = sourceBuilder.isTopLevelFeature();
        this.ownOutput = sourceBuilder.hasOwnOutput();
        this.source = sourceBuilder.getSource();
    }

    public TemplateBuilderContext evaluateSource(TemplateBuilderContext context) {
        if (this.source != null && !this.getStrSource().equals(context.getCurrentSource())) {
            Object o = this.evaluateSource(context.getCurrentObj());
            TemplateBuilderContext newContext = new TemplateBuilderContext(o, this.getStrSource());
            newContext.setParent(context);
            return newContext;
        }
        return context;
    }

    public Object evaluateSource(Object o) {
        if (!(this.source instanceof AttributeExpressionImpl)) {
            AttributeExpressionImpl sourceToEval = new AttributeExpressionImpl(this.source.evaluate(null).toString(), this.namespaces);
            return sourceToEval.evaluate(o);
        }
        return this.source.evaluate(o);
    }

    public Expression getSource() {
        if (!(this.source instanceof AttributeExpressionImpl) && this.source != null) {
            return new AttributeExpressionImpl(this.source.evaluate(null).toString(), this.namespaces);
        }
        return this.source;
    }

    public String getStrSource() {
        if (this.source == null) {
            return null;
        }
        if (this.source instanceof AttributeExpressionImpl) {
            return ((AttributeExpressionImpl)this.source).getPropertyName();
        }
        return Optional.ofNullable(this.source.evaluate(null)).map(o -> o.toString()).orElse(null);
    }

    public void setSource(String source) {
        TemplateCQLManager cqlManager = new TemplateCQLManager(source, this.namespaces);
        Expression sourceExpr = cqlManager.getExpressionFromString();
        this.source = sourceExpr instanceof Literal ? new AttributeExpressionImpl(sourceExpr.evaluate(null).toString(), this.namespaces) : sourceExpr;
    }

    public boolean hasOwnOutput() {
        return this.ownOutput;
    }

    public void setOwnOutput(boolean ownOutput) {
        this.ownOutput = ownOutput;
    }

    protected void addSkipObjectEncodingHint(TemplateBuilderContext context) {
        if (this.topLevelFeature) {
            this.addEncodingHint("SKIP_OBJECT_ENCODING", true);
        }
    }

    public boolean isTopLevelFeature() {
        return this.topLevelFeature;
    }

    public void setTopLevelFeature(boolean topLevelFeature) {
        this.topLevelFeature = topLevelFeature;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.source, this.ownOutput, this.topLevelFeature);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SourceBuilder that = (SourceBuilder)o;
        return this.ownOutput == that.ownOutput && this.topLevelFeature == that.topLevelFeature && Objects.equals(this.source, that.source);
    }
}

