/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.featurestemplating.builders;

import java.util.HashMap;
import java.util.Optional;
import org.geotools.api.filter.expression.Expression;
import org.geotools.util.Converters;
import org.springframework.web.context.request.RequestContextHolder;

public class EncodingHints
extends HashMap<String, Object> {
    public static final String CONTEXT = "@context";
    public static final String NAMESPACES = "NAMESPACES";
    public static final String SCHEMA_LOCATION = "SCHEMA_LOCATION";
    public static final String ENCODE_AS_ATTRIBUTE = "ENCODE_AS_ATTRIBUTE";
    public static final String ITERATE_KEY = "INTERATE_KEY";
    public static final String CHILDREN_EVALUATION = "CHILDREN_EVALUATION";
    public static final String SKIP_OBJECT_ENCODING = "SKIP_OBJECT_ENCODING";

    public EncodingHints() {
    }

    public EncodingHints(EncodingHints encodingHints) {
        super(encodingHints);
    }

    public boolean hasHint(String hint) {
        return this.get(hint) != null;
    }

    public <T> T get(String key, Class<T> cast) {
        return cast.cast(this.get(key));
    }

    public <T> T get(String key, Class<T> cast, T defaultValue) {
        Object value;
        Object result = this.get(key);
        if (result instanceof Expression && !Expression.class.isAssignableFrom(cast)) {
            result = ((Expression)result).evaluate(null);
        }
        if ((value = Converters.convert(result, cast)) == null) {
            value = defaultValue;
        }
        return (T)value;
    }

    public static boolean isSingleFeatureRequest() {
        return Optional.ofNullable(RequestContextHolder.getRequestAttributes()).map(att -> (String)att.getAttribute("OGCFeatures:ItemId", 0)).isPresent();
    }
}

