/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.featurestemplating.builders;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.geoserver.featurestemplating.builders.EncodingHints;
import org.geoserver.featurestemplating.builders.TemplateBuilder;
import org.geoserver.featurestemplating.builders.impl.TemplateBuilderContext;
import org.geoserver.featurestemplating.expressions.TemplateCQLManager;
import org.geoserver.featurestemplating.writers.TemplateOutputWriter;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.expression.Expression;
import org.geotools.filter.LiteralExpressionImpl;
import org.geotools.filter.text.cql2.CQLException;
import org.xml.sax.helpers.NamespaceSupport;

public abstract class AbstractTemplateBuilder
implements TemplateBuilder {
    protected Expression key;
    protected Filter filter;
    protected int filterContextPos = 0;
    protected NamespaceSupport namespaces;
    protected List<TemplateBuilder> children;
    protected EncodingHints encodingHints;
    protected TemplateBuilder parent;

    protected AbstractTemplateBuilder() {
    }

    protected AbstractTemplateBuilder(AbstractTemplateBuilder abstractTemplateBuilder, boolean includeChildren) {
        this.key = abstractTemplateBuilder.getKey();
        this.namespaces = abstractTemplateBuilder.getNamespaces();
        this.filter = abstractTemplateBuilder.getFilter();
        this.encodingHints = abstractTemplateBuilder.getEncodingHints();
        if (includeChildren) {
            this.children = abstractTemplateBuilder.getChildren();
            this.parent = abstractTemplateBuilder.getParent();
        } else {
            this.children = new ArrayList<TemplateBuilder>();
        }
    }

    public AbstractTemplateBuilder(String key, NamespaceSupport namespaces) {
        this.key = this.getKeyAsExpression(key, namespaces);
        this.namespaces = namespaces;
        this.children = new ArrayList<TemplateBuilder>();
    }

    protected boolean evaluateFilter(TemplateBuilderContext context) {
        if (this.filter == null) {
            return true;
        }
        TemplateBuilderContext evaluationContenxt = context;
        for (int i = 0; i < this.filterContextPos; ++i) {
            evaluationContenxt = evaluationContenxt.getParent();
        }
        return this.filter.evaluate(evaluationContenxt.getCurrentObj());
    }

    public Expression getKey() {
        return this.key;
    }

    public String getKey(TemplateBuilderContext context) {
        if (this.key == null) {
            return null;
        }
        Object currentObj = context != null ? context.getCurrentObj() : null;
        return (String)this.key.evaluate(currentObj, String.class);
    }

    public void setKey(String key) {
        this.key = this.getKeyAsExpression(key, null);
    }

    public void setKey(Expression key) {
        this.key = key;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public void setFilter(String filter) {
        TemplateCQLManager cqlManager = new TemplateCQLManager(filter, this.namespaces);
        try {
            this.filter = cqlManager.getFilterFromString();
        }
        catch (CQLException e) {
            throw new RuntimeException(e);
        }
        this.filterContextPos = cqlManager.getContextPos();
    }

    public void setFilter(Filter filter) {
        this.filter = filter;
    }

    public int getFilterContextPos() {
        return this.filterContextPos;
    }

    public NamespaceSupport getNamespaces() {
        return this.namespaces;
    }

    private Expression getKeyAsExpression(String key, NamespaceSupport namespaces) {
        LiteralExpressionImpl keyExpr;
        if (key != null) {
            if (key.startsWith("$${") || key.startsWith("${")) {
                TemplateCQLManager cqlManager = new TemplateCQLManager(key, namespaces);
                if (key.startsWith("$${")) {
                    return cqlManager.getExpressionFromString();
                }
                if (key.equals("${.}")) {
                    return cqlManager.getThis();
                }
                if (key.startsWith("${")) {
                    return cqlManager.getAttributeExpressionFromString();
                }
                throw new IllegalArgumentException("Invalid key: " + key);
            }
            keyExpr = new LiteralExpressionImpl((Object)key);
        } else {
            keyExpr = null;
        }
        return keyExpr;
    }

    @Override
    public List<TemplateBuilder> getChildren() {
        return this.children;
    }

    public EncodingHints getEncodingHints() {
        if (this.encodingHints == null) {
            this.encodingHints = new EncodingHints();
        }
        return this.encodingHints;
    }

    @Override
    public void addEncodingHint(String key, Object value) {
        if (this.encodingHints == null) {
            this.encodingHints = new EncodingHints();
        }
        this.encodingHints.put(key, value);
    }

    @Override
    public void addChild(TemplateBuilder builder) {
        if (this.children == null) {
            this.children = new ArrayList<TemplateBuilder>();
        }
        builder.setParent(this);
        this.children.add(builder);
    }

    protected void addChildrenEvaluationToEncodingHints(TemplateOutputWriter writer, TemplateBuilderContext context) {
        if (this.children != null && !this.children.isEmpty()) {
            ChildrenEvaluation childrenEvaluation = this.getChildrenEvaluation(writer, context);
            this.getEncodingHints().put("CHILDREN_EVALUATION", childrenEvaluation);
        }
    }

    protected ChildrenEvaluation getChildrenEvaluation(TemplateOutputWriter writer, TemplateBuilderContext context) {
        ChildrenEvaluation action = () -> {
            for (TemplateBuilder b : this.children) {
                b.evaluate(writer, context);
            }
        };
        return action;
    }

    public boolean canWrite(TemplateBuilderContext context) {
        return true;
    }

    public abstract AbstractTemplateBuilder copy(boolean var1);

    @Override
    public TemplateBuilder getParent() {
        return this.parent;
    }

    @Override
    public void setParent(TemplateBuilder builder) {
        this.parent = builder;
    }

    public int hashCode() {
        return Objects.hash(this.key, this.filter, this.filterContextPos, this.namespaces, this.encodingHints, this.parent);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractTemplateBuilder that = (AbstractTemplateBuilder)o;
        return this.filterContextPos == that.filterContextPos && Objects.equals(this.key, that.key) && Objects.equals(this.filter, that.filter) && Objects.equals(this.namespaces, that.namespaces) && Objects.equals(this.children, that.children) && Objects.equals(this.encodingHints, that.encodingHints) && Objects.equals(this.parent, that.parent);
    }

    @FunctionalInterface
    public static interface ChildrenEvaluation {
        public void evaluate() throws IOException;
    }
}

