/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.featurestemplating.writers;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import net.sf.json.JSONSerializer;
import org.geoserver.featurestemplating.builders.EncodingHints;
import org.geoserver.featurestemplating.builders.impl.RootBuilder;
import org.geoserver.featurestemplating.builders.impl.TemplateBuilderContext;
import org.geoserver.featurestemplating.configuration.TemplateIdentifier;
import org.geoserver.featurestemplating.readers.JSONTemplateReader;
import org.geoserver.featurestemplating.readers.TemplateReaderConfiguration;
import org.geoserver.featurestemplating.writers.GeoJSONWriter;
import org.geoserver.featurestemplating.writers.JSONLDWriter;
import org.geoserver.featurestemplating.writers.TemplateOutputWriter;
import org.geotools.api.feature.Property;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.xml.sax.helpers.NamespaceSupport;

public class JsonWriterTest {
    private SimpleFeature createSimpleFeature() throws URISyntaxException {
        SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
        tb.add("geometry", Point.class);
        tb.add("string", String.class);
        tb.add("integer", Integer.class);
        tb.add("double", Double.class);
        tb.add("url", URI.class);
        tb.add("intArray", Integer[].class);
        tb.add("strArray", String[].class);
        tb.setName("schema");
        SimpleFeatureBuilder fb = new SimpleFeatureBuilder(tb.buildFeatureType());
        GeometryFactory factory = new GeometryFactory();
        Point point = factory.createPoint(new Coordinate(1.0, 1.0));
        fb.set("geometry", (Object)point);
        fb.set("string", (Object)"stringValue");
        fb.set("integer", (Object)1);
        fb.set("double", (Object)0.0);
        fb.set("url", (Object)new URI("http://some/url/to.test"));
        fb.set("intArray", (Object)new Integer[]{0, 1, 2});
        fb.set("strArray", (Object)new String[]{"one", "two", "three"});
        return fb.buildFeature("1");
    }

    @Test
    public void testJsonLDWriterEncodesURL() throws URISyntaxException, IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        SimpleFeature f = this.createSimpleFeature();
        JSONLDWriter writer = new JSONLDWriter(new JsonFactory().createGenerator((OutputStream)baos, JsonEncoding.UTF8));
        writer.writeStartObject();
        for (Property prop : f.getProperties()) {
            writer.writeElementName((Object)prop.getName().toString(), null);
            writer.writeValue(prop.getValue());
        }
        writer.endObject(null, null);
        writer.close();
        String jsonString = new String(baos.toByteArray());
        JSONObject json = (JSONObject)JSONSerializer.toJSON((Object)jsonString);
        Assert.assertEquals((Object)json.getString("url"), (Object)"http://some/url/to.test");
    }

    @Test
    public void testJsonWriterEncodesArrays() throws URISyntaxException, IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        SimpleFeature f = this.createSimpleFeature();
        GeoJSONWriter writer = new GeoJSONWriter(new JsonFactory().createGenerator((OutputStream)baos, JsonEncoding.UTF8));
        writer.writeStartObject();
        for (Property prop : f.getProperties()) {
            writer.writeElementName((Object)prop.getName().toString(), null);
            writer.writeValue(prop.getValue());
        }
        writer.endObject(null, null);
        writer.close();
        String jsonString = new String(baos.toByteArray());
        JSONObject json = (JSONObject)JSONSerializer.toJSON((Object)jsonString);
        JSONArray intArray = json.getJSONArray("intArray");
        MatcherAssert.assertThat((Object)intArray, (Matcher)Matchers.hasItems((Object[])new Integer[]{0, 1, 2}));
        JSONArray strArray = json.getJSONArray("strArray");
        MatcherAssert.assertThat((Object)strArray, (Matcher)Matchers.hasItems((Object[])new String[]{"one", "two", "three"}));
    }

    @Test
    public void testArrayIntegration() throws URISyntaxException, IOException {
        NamespaceSupport namespaceSuport = new NamespaceSupport();
        namespaceSuport.declarePrefix("", "http://www.geoserver.org");
        InputStream is = this.getClass().getResource("arrayTemplate.json").openStream();
        ObjectMapper mapper = new ObjectMapper(new JsonFactory().enable(JsonParser.Feature.ALLOW_COMMENTS));
        JSONTemplateReader templateReader = new JSONTemplateReader(mapper.readTree(is), new TemplateReaderConfiguration(namespaceSuport), Collections.emptyList());
        RootBuilder builder = templateReader.getRootBuilder();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        GeoJSONWriter writer = new GeoJSONWriter(new JsonFactory().createGenerator((OutputStream)baos, JsonEncoding.UTF8));
        SimpleFeature sf = this.createSimpleFeature();
        builder.evaluate((TemplateOutputWriter)writer, new TemplateBuilderContext((Object)sf));
        writer.close();
        String jsonString = new String(baos.toByteArray());
        System.out.println(jsonString);
        JSONObject json = (JSONObject)JSONSerializer.toJSON((Object)jsonString);
        JSONArray intArray = json.getJSONArray("intArray");
        MatcherAssert.assertThat((Object)intArray, (Matcher)Matchers.hasItems((Object[])new Integer[]{0, 1, 2}));
        JSONArray strArray = json.getJSONArray("strArray");
        MatcherAssert.assertThat((Object)strArray, (Matcher)Matchers.hasItems((Object[])new String[]{"one", "two", "three"}));
        JSONArray intObjectArray = json.getJSONArray("intObjectArray");
        Assert.assertEquals((long)3L, (long)intObjectArray.size());
        for (int i = 0; i < 3; ++i) {
            JSONObject jo = (JSONObject)intObjectArray.get(i);
            Assert.assertEquals((long)i, (long)jo.getInt("idx"));
            Assert.assertEquals((Object)("TheInteger" + i), (Object)jo.getString("name"));
        }
        JSONArray strObjectArray = json.getJSONArray("strObjectArray");
        Assert.assertEquals((long)3L, (long)strObjectArray.size());
        String[] names = (String[])sf.getAttribute("strArray");
        for (int i = 0; i < 3; ++i) {
            JSONObject jo = (JSONObject)strObjectArray.get(i);
            Assert.assertEquals((Object)names[i], (Object)jo.getString("id"));
            Assert.assertEquals((Object)("TheString" + names[i]), (Object)jo.getString("name"));
        }
        Assert.assertEquals((long)2L, (long)json.getInt("singleIntItem"));
    }

    @Test
    public void testStaticArray() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        GeoJSONWriter writer = new GeoJSONWriter(new JsonFactory().createGenerator((OutputStream)baos, JsonEncoding.UTF8), TemplateIdentifier.JSON);
        writer.startArray(null, null);
        writer.writeStaticContent(null, (Object)"abc", new EncodingHints());
        writer.writeStaticContent(null, (Object)5, new EncodingHints());
        writer.endArray(null, null);
        writer.close();
        String jsonString = new String(baos.toByteArray());
        JSONArray json = (JSONArray)JSONSerializer.toJSON((Object)jsonString);
        Assert.assertEquals((Object)"abc", (Object)json.get(0));
        Assert.assertEquals((Object)5, (Object)json.get(1));
    }

    @Test
    public void testJsonLDWriterEncodesActualTypesByDefault() throws URISyntaxException, IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        SimpleFeature f = this.createSimpleFeature();
        JSONLDWriter writer = new JSONLDWriter(new JsonFactory().createGenerator((OutputStream)baos, JsonEncoding.UTF8));
        writer.writeStartObject();
        for (Property prop : f.getProperties()) {
            writer.writeElementName((Object)prop.getName().toString(), null);
            writer.writeValue(prop.getValue());
        }
        writer.endObject(null, null);
        writer.close();
        String jsonString = new String(baos.toByteArray());
        JSONObject json = (JSONObject)JSONSerializer.toJSON((Object)jsonString);
        Assert.assertTrue((boolean)(json.getString("string") instanceof String));
        Assert.assertTrue((boolean)(json.get("integer") instanceof Integer));
        Assert.assertTrue((boolean)(json.get("double") instanceof Double));
        JSONObject object = json.getJSONObject("geometry");
        JSONArray coordinates = object.getJSONArray("coordinates");
        for (int i = 0; i < coordinates.size(); ++i) {
            Assert.assertTrue((boolean)(coordinates.get(i) instanceof Number));
        }
    }
}

