/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.featurestemplating.builders.selectionwrappers;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.geoserver.featurestemplating.builders.AbstractTemplateBuilder;
import org.geoserver.featurestemplating.builders.TemplateBuilder;
import org.geoserver.featurestemplating.builders.impl.CompositeBuilder;
import org.geoserver.featurestemplating.builders.impl.DynamicIncludeFlatBuilder;
import org.geoserver.featurestemplating.builders.impl.DynamicMergeBuilder;
import org.geoserver.featurestemplating.builders.impl.DynamicValueBuilder;
import org.geoserver.featurestemplating.builders.impl.StaticBuilder;
import org.geoserver.featurestemplating.builders.impl.TemplateBuilderContext;
import org.geoserver.featurestemplating.builders.selectionwrappers.CompositePropertySelection;
import org.geoserver.featurestemplating.builders.selectionwrappers.DynamicPropertySelection;
import org.geoserver.featurestemplating.builders.selectionwrappers.IncludeFlatPropertySelection;
import org.geoserver.featurestemplating.builders.selectionwrappers.MergePropertySelection;
import org.geoserver.featurestemplating.builders.selectionwrappers.PropertySelectionWrapper;
import org.geoserver.featurestemplating.builders.selectionwrappers.StaticPropertySelection;
import org.geoserver.featurestemplating.builders.visitors.AbstractPropertySelection;
import org.geoserver.featurestemplating.builders.visitors.PropertySelectionHandler;
import org.geoserver.featurestemplating.configuration.TemplateIdentifier;
import org.geoserver.featurestemplating.writers.GeoJSONWriter;
import org.geoserver.featurestemplating.writers.TemplateOutputWriter;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.data.DataTestCase;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.xml.sax.helpers.NamespaceSupport;

public class PropertySelectionWrappersTest
extends DataTestCase {
    private static final String BASE_JSON_NODE = "{\n  \"attr1\":\"${attr1}\",\n  \"attr2\":\"${attr2}\",\n  \"attrE\":\"${attrE}\",\n  \"attr3\":{\n     \"attr4\":\"${attr4}\"\n  }\n   }";
    private static final String JSON_ATTRIBUTE = "{\n  \"attrA\":\"a\",\n  \"attrB\": {\n     \"attrC\":\"c\",\n     \"attrD\":\"d\"\n  },\n  \"attrE\":\"e\"\n}";
    private String TYPE_NAME = "propertySel";
    private SimpleFeature feature;

    @Before
    public void setup() {
        SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
        tb.userData((Object)"org.geotools.jdbc.nativeTypeName", (Object)"json");
        tb.add("attr1", String.class);
        tb.add("attr2", Double.class);
        tb.add("attrE", Integer.class);
        tb.add("attr4", String.class);
        tb.add("jsonField", String.class);
        tb.setName(this.TYPE_NAME);
        SimpleFeatureType schema = tb.buildFeatureType();
        schema.getDescriptor("jsonField").getUserData().put("org.geotools.jdbc.nativeTypeName", "json");
        SimpleFeatureBuilder fb = new SimpleFeatureBuilder(schema);
        fb.add((Object)"attr1Value");
        fb.add((Object)0.2);
        fb.add((Object)10);
        fb.add((Object)"attr4 value");
        fb.add((Object)JSON_ATTRIBUTE);
        this.feature = fb.buildFeature(this.TYPE_NAME.concat(".1"));
    }

    @Test
    public void testIncludeFlatSelection() throws IOException {
        DynamicIncludeFlatBuilder builder = new DynamicIncludeFlatBuilder("${jsonField}", new NamespaceSupport(), this.readJsonString(BASE_JSON_NODE));
        AbstractPropertySelection propertySelection = new AbstractPropertySelection(){

            protected boolean isKeySelected(String key) {
                return key == null || !key.endsWith("attrC");
            }

            public boolean hasSelectableJsonValue(AbstractTemplateBuilder builder) {
                return true;
            }
        };
        IncludeFlatPropertySelection wrapper = new IncludeFlatPropertySelection(builder, (PropertySelectionHandler)propertySelection);
        String result = this.encodeTemplateToString((TemplateBuilder)wrapper);
        JsonNode node = this.readJsonString(result);
        ObjectNode object = (ObjectNode)node;
        Assert.assertEquals((Object)"attr1Value", (Object)object.get("attr1").asText());
        Assert.assertEquals((double)0.2, (double)object.get("attr2").asDouble(), (double)0.0);
        Assert.assertEquals((Object)"e", (Object)object.get("attrE").asText());
        Assert.assertEquals((Object)"attr4 value", (Object)object.get("attr3").get("attr4").asText());
        ObjectNode childB = (ObjectNode)object.get("attrB");
        Assert.assertFalse((boolean)childB.has("attrC"));
        Assert.assertEquals((Object)"d", (Object)childB.get("attrD").asText());
    }

    @Test
    public void testMergeSelection() throws IOException {
        DynamicMergeBuilder builder = new DynamicMergeBuilder("nestedAttr", "${jsonField}", new NamespaceSupport(), this.readJsonString(BASE_JSON_NODE), true);
        AbstractPropertySelection propertySelection = new AbstractPropertySelection(){

            protected boolean isKeySelected(String key) {
                return key == null || !key.endsWith("attrD");
            }

            public boolean hasSelectableJsonValue(AbstractTemplateBuilder builder) {
                return true;
            }
        };
        MergePropertySelection wrapper = new MergePropertySelection(builder, (PropertySelectionHandler)propertySelection);
        String result = this.encodeTemplateToString((TemplateBuilder)wrapper);
        JsonNode node = this.readJsonString(result);
        ObjectNode object = (ObjectNode)node.get("nestedAttr");
        Assert.assertEquals((Object)"attr1Value", (Object)object.get("attr1").asText());
        Assert.assertEquals((double)0.2, (double)object.get("attr2").asDouble(), (double)0.0);
        Assert.assertEquals((Object)"e", (Object)object.get("attrE").asText());
        Assert.assertEquals((Object)"attr4 value", (Object)object.get("attr3").get("attr4").asText());
        ObjectNode childB = (ObjectNode)object.get("attrB");
        Assert.assertFalse((boolean)childB.has("attrD"));
        Assert.assertEquals((Object)"c", (Object)childB.get("attrC").asText());
    }

    @Test
    public void testStaticSelection() throws IOException {
        StaticBuilder builder = new StaticBuilder("staticBuilder", this.readJsonString(JSON_ATTRIBUTE), new NamespaceSupport());
        AbstractPropertySelection propertySelection = new AbstractPropertySelection(){

            protected boolean isKeySelected(String key) {
                return key == null || !key.endsWith("attrB");
            }

            public boolean hasSelectableJsonValue(AbstractTemplateBuilder builder) {
                return true;
            }
        };
        StaticPropertySelection wrapper = new StaticPropertySelection(builder, (PropertySelectionHandler)propertySelection);
        String result = this.encodeTemplateToString((TemplateBuilder)wrapper);
        JsonNode node = this.readJsonString(result);
        ObjectNode object = (ObjectNode)node.get("staticBuilder");
        Assert.assertEquals((long)2L, (long)object.size());
        Assert.assertEquals((Object)"a", (Object)object.get("attrA").asText());
        Assert.assertEquals((Object)"e", (Object)object.get("attrE").asText());
    }

    @Test
    public void testCompositeWithDynamicKey() throws IOException {
        AbstractPropertySelection propertySelection = new AbstractPropertySelection(){

            protected boolean isKeySelected(String key) {
                return key == null || !key.endsWith("attr1Value");
            }

            public boolean hasSelectableJsonValue(AbstractTemplateBuilder builder) {
                return true;
            }
        };
        CompositeBuilder builder = new CompositeBuilder("${attr1}", new NamespaceSupport(), false);
        CompositeBuilder builder2 = new CompositeBuilder("${attr2}", new NamespaceSupport(), false);
        DynamicValueBuilder dynamicValueBuilder = new DynamicValueBuilder("nested", "${jsonField}", new NamespaceSupport());
        builder.addChild((TemplateBuilder)new DynamicPropertySelection(dynamicValueBuilder, (PropertySelectionHandler)propertySelection));
        StaticBuilder staticBuilder = new StaticBuilder("staticBuilder", this.readJsonString(JSON_ATTRIBUTE), new NamespaceSupport());
        builder2.addChild((TemplateBuilder)new StaticPropertySelection(staticBuilder, (PropertySelectionHandler)propertySelection));
        CompositePropertySelection one = new CompositePropertySelection(builder, (PropertySelectionHandler)propertySelection);
        CompositePropertySelection two = new CompositePropertySelection(builder2, (PropertySelectionHandler)propertySelection);
        CompositeBuilder container = new CompositeBuilder("container", new NamespaceSupport(), false);
        container.addChild((TemplateBuilder)one);
        container.addChild((TemplateBuilder)two);
        String result = this.encodeTemplateToString((TemplateBuilder)new PropertySelectionWrapper((AbstractTemplateBuilder)container, (PropertySelectionHandler)propertySelection));
        JsonNode node = this.readJsonString(result);
        ObjectNode object = (ObjectNode)node.get("container");
        ObjectNode dynamicKeySelected = (ObjectNode)object.get("0.2");
        Assert.assertFalse((boolean)object.has("attr1Value"));
    }

    private JsonNode readJsonString(String json) throws JsonProcessingException {
        ObjectMapper mapper = new ObjectMapper();
        return mapper.readTree(json);
    }

    private String encodeTemplateToString(TemplateBuilder builder) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        GeoJSONWriter writer = new GeoJSONWriter(new JsonFactory().createGenerator((OutputStream)baos, JsonEncoding.UTF8), TemplateIdentifier.JSON);
        writer.writeStartObject();
        builder.evaluate((TemplateOutputWriter)writer, new TemplateBuilderContext((Object)this.feature));
        writer.writeEndObject();
        writer.close();
        return new String(baos.toByteArray());
    }
}

