/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.featurestemplating.builders.impl;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import net.sf.json.JSONSerializer;
import org.geoserver.featurestemplating.builders.impl.DynamicIncludeFlatBuilder;
import org.geoserver.featurestemplating.builders.impl.TemplateBuilderContext;
import org.geoserver.featurestemplating.configuration.TemplateIdentifier;
import org.geoserver.featurestemplating.writers.GeoJSONWriter;
import org.geoserver.featurestemplating.writers.TemplateOutputWriter;
import org.geotools.api.feature.Feature;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.data.DataTestCase;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.xml.sax.helpers.NamespaceSupport;

public class DynamicIncludeFlatBuilderTest
extends DataTestCase {
    private static final String BASE = "{\"someStaticValue\":\"theValue\"}";
    private static final String DYNAMIC_METADATA = "{\"metadata\":{\"metadata_iso_19139\":{\"title\":\"metadata_iso_19139\",\"dynamicValue\":\"${dynamicValue}\",\"href\":\"http://metadata_iso_19139.org\",\"type\":\"metadata\"}}}";
    private static final String STATIC_METADATA = "{\"metadata\":{\"metadata_iso_19139\":{\"title\":\"metadata_iso_19139\",\"href\":\"http://metadata_iso_19139.org\",\"type\":\"metadata\"}}}";
    private static final String ARRAY_METADATA = "{\"array\":[1,2,3,4], \"anotherArray\":[\"one\",\"two\",\"three\",\"four\"]}";
    private SimpleFeature jsonFieldSimpleFeature;

    @Before
    public void setup() throws Exception {
        SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
        tb.userData((Object)"org.geotools.jdbc.nativeTypeName", (Object)"json");
        tb.add("dynamicMetadata", String.class);
        tb.add("staticMetadata", String.class);
        tb.add("dynamicValue", String.class);
        tb.add("arrayMetadata", String.class);
        tb.add("nullMetadata", String.class);
        tb.setName("jsonFieldSimpleType");
        SimpleFeatureType schema = tb.buildFeatureType();
        schema.getDescriptor("dynamicMetadata").getUserData().put("org.geotools.jdbc.nativeTypeName", "json");
        schema.getDescriptor("staticMetadata").getUserData().put("org.geotools.jdbc.nativeTypeName", "json");
        schema.getDescriptor("arrayMetadata").getUserData().put("org.geotools.jdbc.nativeTypeName", "json");
        SimpleFeatureBuilder fb = new SimpleFeatureBuilder(schema);
        fb.add((Object)DYNAMIC_METADATA);
        fb.add((Object)STATIC_METADATA);
        fb.add((Object)"dynamic value result");
        fb.add((Object)ARRAY_METADATA);
        this.jsonFieldSimpleFeature = fb.buildFeature("jsonFieldSimpleType.1");
    }

    @Test
    public void testDynamicIncludeFlatDynamicResult() throws Exception {
        String message = null;
        try {
            this.encodeDynamicIncludeFlat("${dynamicMetadata}", (Feature)this.jsonFieldSimpleFeature, BASE);
        }
        catch (UnsupportedOperationException e) {
            message = e.getMessage();
        }
        Assert.assertEquals((Object)message, (Object)"A json attribute value cannot have a template directive among its fields.");
    }

    @Test
    public void testDynamicIncludeFlatStaticResult() throws Exception {
        JSONObject json = this.encodeDynamicIncludeFlat("${staticMetadata}", (Feature)this.jsonFieldSimpleFeature, BASE);
        JSONObject metadata19139 = json.getJSONObject("metadata").getJSONObject("metadata_iso_19139");
        Assert.assertEquals((Object)"metadata_iso_19139", (Object)metadata19139.getString("title"));
        Assert.assertEquals((Object)"http://metadata_iso_19139.org", (Object)metadata19139.getString("href"));
        Assert.assertEquals((Object)"metadata", (Object)metadata19139.getString("type"));
    }

    @Test
    public void testDynamicIncludeFlatMultipleArrays() throws Exception {
        JSONObject json = this.encodeDynamicIncludeFlat("${arrayMetadata}", (Feature)this.jsonFieldSimpleFeature, BASE);
        JSONArray array1 = json.getJSONArray("array");
        JSONArray array2 = json.getJSONArray("anotherArray");
        for (int i = 0; i < array1.size(); ++i) {
            Assert.assertEquals((long)array1.getInt(i), (long)(i + 1));
        }
        Assert.assertEquals((Object)array2.getString(0), (Object)"one");
        Assert.assertEquals((Object)array2.getString(1), (Object)"two");
        Assert.assertEquals((Object)array2.getString(2), (Object)"three");
        Assert.assertEquals((Object)array2.getString(3), (Object)"four");
    }

    @Test
    public void testDynamicIncludeFlatOnNull() throws Exception {
        JSONObject json = this.encodeDynamicIncludeFlat("${nullMetadata}", (Feature)this.jsonFieldSimpleFeature, BASE);
        Assert.assertEquals((long)1L, (long)json.size());
        Assert.assertEquals((Object)"theValue", (Object)json.getString("someStaticValue"));
    }

    private JSONObject encodeDynamicIncludeFlat(String expression, Feature feature, String baseNode) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        GeoJSONWriter writer = new GeoJSONWriter(new JsonFactory().createGenerator((OutputStream)baos, JsonEncoding.UTF8), TemplateIdentifier.JSON);
        ObjectMapper objectMapper = new ObjectMapper();
        JsonNode base = objectMapper.readTree(baseNode);
        DynamicIncludeFlatBuilder builder = new DynamicIncludeFlatBuilder(expression, new NamespaceSupport(), base);
        writer.writeStartObject();
        builder.evaluate((TemplateOutputWriter)writer, new TemplateBuilderContext((Object)feature));
        writer.writeEndObject();
        writer.close();
        String jsonString = new String(baos.toByteArray());
        return (JSONObject)JSONSerializer.toJSON((Object)jsonString);
    }
}

