/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.featurestemplating.request;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import org.geoserver.featurestemplating.builders.impl.RootBuilder;
import org.geoserver.featurestemplating.readers.JSONTemplateReader;
import org.geoserver.featurestemplating.readers.TemplateReaderConfiguration;
import org.geoserver.featurestemplating.request.TemplatePathVisitor;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.expression.ExpressionVisitor;
import org.geotools.api.filter.expression.PropertyName;
import org.geotools.factory.CommonFactoryFinder;
import org.junit.Assert;
import org.junit.Test;
import org.xml.sax.helpers.NamespaceSupport;

public class TemplatePathVisitorTest {
    FilterFactory FF = CommonFactoryFinder.getFilterFactory();

    @Test
    public void testBackwardMapping() throws IOException {
        RootBuilder rootBuilder = this.getBuilderTree("testTemplateBackwardMapping.json");
        TemplatePathVisitor pathVisitor = new TemplatePathVisitor(false);
        PropertyName pn = this.FF.property("root/nested/nested2/g");
        PropertyName result = (PropertyName)pn.accept((ExpressionVisitor)pathVisitor, (Object)rootBuilder);
        Assert.assertEquals((Object)"a/b/c/d/e/e/f/g", (Object)result.getPropertyName());
    }

    @Test
    public void testBackwardMappingWithBackDotsProps() throws IOException {
        RootBuilder rootBuilder = this.getBuilderTree("testTemplateBackwardMapping.json");
        TemplatePathVisitor pathVisitor = new TemplatePathVisitor(false);
        PropertyName pn = this.FF.property("root/e");
        PropertyName result = (PropertyName)pn.accept((ExpressionVisitor)pathVisitor, (Object)rootBuilder);
        Assert.assertEquals((Object)"b/c/d/e", (Object)result.getPropertyName());
    }

    @Test
    public void testBackwardMappingWithBackDotsProps2() throws IOException {
        RootBuilder rootBuilder = this.getBuilderTree("testTemplateBackwardMapping.json");
        TemplatePathVisitor pathVisitor = new TemplatePathVisitor(false);
        PropertyName pn = this.FF.property("root/nested/d");
        PropertyName result = (PropertyName)pn.accept((ExpressionVisitor)pathVisitor, (Object)rootBuilder);
        Assert.assertEquals((Object)"a/b/b/c/d", (Object)result.getPropertyName());
    }

    @Test
    public void testBackwardMappingWithBackDotsProps3() throws IOException {
        RootBuilder rootBuilder = this.getBuilderTree("testTemplateBackwardMapping.json");
        TemplatePathVisitor pathVisitor = new TemplatePathVisitor(false);
        PropertyName pn = this.FF.property("root/nested/nested2/f");
        PropertyName result = (PropertyName)pn.accept((ExpressionVisitor)pathVisitor, (Object)rootBuilder);
        Assert.assertEquals((Object)"a/b/b/e/f", (Object)result.getPropertyName());
    }

    private RootBuilder getBuilderTree(String resourceName) throws IOException {
        InputStream is = this.getClass().getResource(resourceName).openStream();
        ObjectMapper mapper = new ObjectMapper(new JsonFactory().enable(JsonParser.Feature.ALLOW_COMMENTS));
        JSONTemplateReader templateReader = new JSONTemplateReader(mapper.readTree(is), new TemplateReaderConfiguration(new NamespaceSupport()), Collections.emptyList());
        return templateReader.getRootBuilder();
    }
}

