/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.featurestemplating.readers;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.function.Predicate;
import org.geoserver.featurestemplating.builders.TemplateBuilder;
import org.geoserver.featurestemplating.builders.VendorOptions;
import org.geoserver.featurestemplating.builders.flat.FlatBuilder;
import org.geoserver.featurestemplating.builders.impl.CompositeBuilder;
import org.geoserver.featurestemplating.builders.impl.DynamicValueBuilder;
import org.geoserver.featurestemplating.builders.impl.IteratingBuilder;
import org.geoserver.featurestemplating.builders.impl.RootBuilder;
import org.geoserver.featurestemplating.builders.impl.StaticBuilder;
import org.geoserver.featurestemplating.expressions.XpathFunction;
import org.geoserver.featurestemplating.readers.JSONTemplateReader;
import org.geoserver.featurestemplating.readers.TemplateReaderConfiguration;
import org.geotools.api.filter.PropertyIsEqualTo;
import org.geotools.api.filter.expression.Function;
import org.geotools.api.filter.expression.PropertyName;
import org.geotools.filter.function.EnvFunction;
import org.geotools.filter.text.cql2.CQLException;
import org.geotools.filter.text.ecql.ECQL;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.xml.sax.helpers.NamespaceSupport;

public class JsonTemplateReaderTest {
    NamespaceSupport namespaceSuport;

    @Before
    public void setupNamespaceSupport() {
        this.namespaceSuport = new NamespaceSupport();
        this.namespaceSuport.declarePrefix("", "http://www.geoserver.org");
    }

    @Test
    public void testVendorOptionWithEnvFunction() throws IOException {
        RootBuilder root = this.getBuilderTree("FlatGeoJSONMappedFeature.json");
        this.testBuildersType(root.getChildren(), b -> b instanceof FlatBuilder);
        HashMap<String, String> envValues = new HashMap<String, String>();
        envValues.put("flat_output", "false");
        EnvFunction.setLocalValues(envValues);
        root = this.getBuilderTree("FlatGeoJSONMappedFeature.json");
        this.testBuildersType(root.getChildren(), b -> !(b instanceof FlatBuilder));
    }

    @Test
    public void testNestedArray() throws IOException, CQLException {
        RootBuilder root = this.getBuilderTree("nestedArray.json");
        IteratingBuilder it = (IteratingBuilder)root.getChildren().get(0);
        Assert.assertEquals((Object)"bbox", (Object)it.getKey(null));
        IteratingBuilder nested = (IteratingBuilder)it.getChildren().get(0);
        Assert.assertNull((Object)nested.getKey());
    }

    @Test
    public void testArrayWithoutSource() throws IOException, CQLException {
        RootBuilder root = this.getBuilderTree("arrayWithoutSource.json");
        IteratingBuilder it = (IteratingBuilder)root.getChildren().get(0);
        CompositeBuilder cb1 = (CompositeBuilder)it.getChildren().get(0);
        Assert.assertEquals((Object)ECQL.toFilter((String)"name = 'LANDSAT8'"), (Object)cb1.getFilter());
        PropertyIsEqualTo pe = (PropertyIsEqualTo)cb1.getFilter();
        PropertyName pnName = (PropertyName)pe.getExpression1();
        Assert.assertEquals((Object)this.namespaceSuport, (Object)pnName.getNamespaceContext());
        CompositeBuilder cb2 = (CompositeBuilder)it.getChildren().get(1);
        Assert.assertNull((Object)cb2.getFilter());
        DynamicValueBuilder db2 = (DynamicValueBuilder)cb2.getChildren().get(0);
        Assert.assertEquals((Object)"name", (Object)db2.getKey(null));
        Assert.assertEquals((Object)ECQL.toExpression((String)"strSubstring(name, 1, 5)"), (Object)db2.getCql());
        Function fn = (Function)db2.getCql();
        PropertyName fname = (PropertyName)fn.getParameters().get(0);
        Assert.assertEquals((Object)this.namespaceSuport, (Object)fname.getNamespaceContext());
        CompositeBuilder cb3 = (CompositeBuilder)it.getChildren().get(2);
        Assert.assertEquals((Object)ECQL.toFilter((String)"xpath('name') = 'SENTINEL2'"), (Object)cb3.getFilter());
        PropertyIsEqualTo peXPath = (PropertyIsEqualTo)cb3.getFilter();
        XpathFunction xpath = (XpathFunction)peXPath.getExpression1();
        Assert.assertEquals((Object)this.namespaceSuport, (Object)xpath.getNamespaceContext());
        MatcherAssert.assertThat((Object)((TemplateBuilder)it.getChildren().get(3)), (Matcher)CoreMatchers.instanceOf(StaticBuilder.class));
    }

    @Test
    public void testOptionsParsingForRootAttributes() throws IOException {
        RootBuilder root = this.getBuilderTree("jsonld_custom_root_attrs.json");
        VendorOptions options = root.getVendorOptions();
        Assert.assertEquals((Object)"diseaseSpreadStatistics", (Object)options.get("collection_name", String.class));
        Assert.assertEquals((Object)"schema:SpecialAnnouncement", (Object)options.get("@type", String.class));
    }

    private RootBuilder getBuilderTree(String resourceName) throws IOException {
        InputStream is = this.getClass().getResource(resourceName).openStream();
        ObjectMapper mapper = new ObjectMapper(new JsonFactory().enable(JsonParser.Feature.ALLOW_COMMENTS));
        JSONTemplateReader templateReader = new JSONTemplateReader(mapper.readTree(is), new TemplateReaderConfiguration(this.namespaceSuport), Collections.emptyList());
        return templateReader.getRootBuilder();
    }

    private void testBuildersType(List<TemplateBuilder> builders, Predicate<TemplateBuilder> predicate) {
        for (TemplateBuilder builder : builders) {
            Assert.assertTrue((boolean)predicate.test(builder));
            if (builder.getChildren() == null) continue;
            this.testBuildersType(builder.getChildren(), predicate);
        }
    }
}

