/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.featurestemplating.readers;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import org.geoserver.featurestemplating.builders.impl.RootBuilder;
import org.geoserver.featurestemplating.readers.JSONTemplateReader;
import org.geoserver.featurestemplating.readers.RecursiveJSONParser;
import org.geoserver.featurestemplating.readers.TemplateReaderConfiguration;
import org.geoserver.platform.resource.FileSystemResourceStore;
import org.geoserver.platform.resource.Resource;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.xml.sax.helpers.NamespaceSupport;

public class JSONIncludesTest {
    FileSystemResourceStore store;

    @Before
    public void setupStore() {
        this.store = new FileSystemResourceStore(new File("src/test/resources/jsonIncludes"));
    }

    @Test
    public void testArrayInclusion() throws Exception {
        RecursiveJSONParser parser = new RecursiveJSONParser(this.store.get("includeInArray.json"));
        JsonNode parsed = parser.parse();
        this.checkArrayInclusion(parsed);
    }

    private void checkArrayInclusion(JsonNode parsed) {
        Assert.assertEquals((Object)"test for array inclusion", (Object)parsed.get("name").textValue());
        JsonNode array = parsed.get("arrayProperty");
        Assert.assertEquals((Object)JsonNodeType.ARRAY, (Object)array.getNodeType());
        Assert.assertEquals((Object)"first", (Object)array.get(0).textValue());
        JsonNode object = array.get(1);
        Assert.assertEquals((Object)JsonNodeType.OBJECT, (Object)object.getNodeType());
        Assert.assertEquals((long)10L, (long)object.get("int").intValue());
        Assert.assertEquals((Object)"abc", (Object)object.get("text").textValue());
        Assert.assertEquals((long)1L, (long)object.get("object").get("a").intValue());
        JsonNode na = array.get(2);
        Assert.assertEquals((Object)JsonNodeType.ARRAY, (Object)na.getNodeType());
        Assert.assertEquals((Object)"one", (Object)na.get(0).textValue());
        Assert.assertEquals((Object)"two", (Object)na.get(1).get("name").textValue());
        Assert.assertEquals((long)3L, (long)na.get(2).intValue());
        Assert.assertEquals((Object)"one", (Object)array.get(3).textValue());
        Assert.assertEquals((Object)"two", (Object)array.get(4).get("name").textValue());
        Assert.assertEquals((long)3L, (long)array.get(5).intValue());
        Assert.assertEquals((Object)"last", (Object)array.get(6).textValue());
        Assert.assertEquals((Object)"endMarker", (Object)parsed.get("end").textValue());
    }

    @Test
    public void checkObjectInclusion() throws Exception {
        RecursiveJSONParser parser = new RecursiveJSONParser(this.store.get("includeInObject.json"));
        JsonNode parsed = parser.parse();
        this.checkObjectInclusion(parsed);
    }

    @Test
    public void checkObjectInclusionSubdirDownwards() throws Exception {
        RecursiveJSONParser parser = new RecursiveJSONParser(this.store.get("includeInObjectSubdir.json"));
        JsonNode parsed = parser.parse();
        this.checkObjectInclusion(parsed);
    }

    @Test
    public void checkObjectInclusionSubdirRelativeUp() {
        RuntimeException ex = this.checkThrowingTemplate("subdir/includeInObjectRelativeUp.json");
        Assert.assertEquals((Object)"Contains invalid '..' path: subdir/../object.json", (Object)ex.getMessage());
    }

    @Test
    public void checkObjectInclusionSubdirAbsoluteUp() throws IOException {
        RecursiveJSONParser parser = new RecursiveJSONParser(this.store.get("subdir/includeInObjectAbsoluteUp.json"));
        JsonNode parsed = parser.parse();
        this.checkObjectInclusion(parsed);
    }

    @Test
    public void checkObjectInclusionRelativeDot() throws IOException {
        RecursiveJSONParser parser = new RecursiveJSONParser(this.store.get("includeInObjectRelativeDot.json"));
        JsonNode parsed = parser.parse();
        this.checkObjectInclusion(parsed);
    }

    private void checkObjectInclusion(JsonNode parsed) {
        Assert.assertEquals((Object)"test for object inclusion", (Object)parsed.get("name").textValue());
        JsonNode object = parsed.get("myObjectProperty");
        Assert.assertEquals((Object)JsonNodeType.OBJECT, (Object)object.getNodeType());
        Assert.assertEquals((long)10L, (long)object.get("int").intValue());
        Assert.assertEquals((Object)"abc", (Object)object.get("text").textValue());
        Assert.assertEquals((long)1L, (long)object.get("object").get("a").intValue());
        JsonNode array = parsed.get("myArrayProperty");
        Assert.assertEquals((Object)JsonNodeType.ARRAY, (Object)array.getNodeType());
        Assert.assertEquals((Object)"one", (Object)array.get(0).textValue());
        Assert.assertEquals((Object)"two", (Object)array.get(1).get("name").textValue());
        Assert.assertEquals((long)3L, (long)array.get(2).intValue());
        Assert.assertEquals((long)10L, (long)parsed.get("int").intValue());
        Assert.assertEquals((Object)"abc", (Object)parsed.get("text").textValue());
        Assert.assertEquals((long)1L, (long)object.get("object").get("a").intValue());
        Assert.assertEquals((Object)"endMarker", (Object)parsed.get("end").textValue());
    }

    @Test
    public void testNestedInclusion() throws Exception {
        RecursiveJSONParser parser = new RecursiveJSONParser(this.store.get("nestedInclusion.json"));
        JsonNode parsed = parser.parse();
        Assert.assertEquals((Object)"test for nested inclusion", (Object)parsed.get("name").textValue());
        this.checkObjectInclusion(parsed.get("obj1"));
        this.checkArrayInclusion(parsed.get("obj2"));
        JsonNode flat = parsed.get("obj3");
        this.checkObjectInclusion(flat);
        Assert.assertEquals((Object)"first", (Object)flat.get("o3First").asText());
        Assert.assertEquals((Object)"last", (Object)flat.get("o3Last").asText());
        Assert.assertEquals((Object)"endMarker", (Object)parsed.get("topLevelEnd").textValue());
    }

    @Test
    public void testRecursionLimited() {
        RuntimeException ex = this.checkThrowingTemplate("recurse.json");
        MatcherAssert.assertThat((Object)ex.getMessage(), (Matcher)CoreMatchers.containsString((String)"Went beyond maximum expansion depth (51), chain is: [recurse.json"));
    }

    @Test
    public void testDanglingInclude() {
        RuntimeException ex = this.checkThrowingTemplate("dangling.json");
        Assert.assertEquals((Object)"Path notThere.json does not exist", (Object)ex.getMessage());
    }

    @Test
    public void testRecursionPingPong() {
        RuntimeException ex = this.checkThrowingTemplate("ping.json");
        MatcherAssert.assertThat((Object)ex.getMessage(), (Matcher)CoreMatchers.containsString((String)"Went beyond maximum expansion depth (51), chain is: [ping.json"));
        MatcherAssert.assertThat((Object)ex.getMessage(), (Matcher)CoreMatchers.containsString((String)"pong.json"));
    }

    @Test
    public void testIncludedModificationAreDetected() throws IOException, InterruptedException {
        Resource resource = this.store.get("includeInObject.json");
        RecursiveJSONParser parser = new RecursiveJSONParser(resource);
        TemplateReaderConfiguration configuration = new TemplateReaderConfiguration(new NamespaceSupport());
        JSONTemplateReader reader = new JSONTemplateReader(parser.parse(), configuration, parser.getWatchers());
        RootBuilder rootBuilder = reader.getRootBuilder();
        Assert.assertFalse((boolean)rootBuilder.needsReload());
        Resource included = this.store.get("object.json");
        File file = included.file();
        file.setLastModified(new Date().getTime());
        for (int i = 0; i < 600; ++i) {
            if (rootBuilder.needsReload()) {
                return;
            }
            Thread.sleep(100L);
        }
        Assert.fail((String)"Should have found a reload 60 seconds, but did not");
    }

    @Test
    public void testObtainDynamicIncludeFlatKeyword() throws IOException {
        RecursiveJSONParser parser = new RecursiveJSONParser(this.store.get("dynamicIncludeFlat.json"));
        JsonNode parse = parser.parse();
        Assert.assertTrue((boolean)parse.toString().contains("$includeFlat"));
    }

    private RuntimeException checkThrowingTemplate(String s) {
        return (RuntimeException)Assert.assertThrows(RuntimeException.class, () -> new RecursiveJSONParser(this.store.get(s)).parse());
    }
}

