/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.featurestemplating.builders.visitors;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.geoserver.featurestemplating.builders.AbstractTemplateBuilder;
import org.geoserver.featurestemplating.builders.TemplateBuilder;
import org.geoserver.featurestemplating.builders.impl.DynamicValueBuilder;
import org.geoserver.featurestemplating.builders.impl.RootBuilder;
import org.geoserver.featurestemplating.builders.impl.StaticBuilder;
import org.geoserver.featurestemplating.builders.selectionwrappers.DynamicPropertySelection;
import org.geoserver.featurestemplating.builders.selectionwrappers.IncludeFlatPropertySelection;
import org.geoserver.featurestemplating.builders.selectionwrappers.MergePropertySelection;
import org.geoserver.featurestemplating.builders.selectionwrappers.StaticPropertySelection;
import org.geoserver.featurestemplating.builders.visitors.AbstractPropertySelection;
import org.geoserver.featurestemplating.builders.visitors.PropertySelectionHandler;
import org.geoserver.featurestemplating.builders.visitors.PropertySelectionVisitor;
import org.geoserver.featurestemplating.builders.visitors.TemplateVisitor;
import org.geoserver.featurestemplating.readers.JSONTemplateReader;
import org.geoserver.featurestemplating.readers.RecursiveJSONParser;
import org.geoserver.featurestemplating.readers.TemplateReaderConfiguration;
import org.geoserver.platform.resource.FileSystemResourceStore;
import org.geoserver.platform.resource.Resource;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.PropertyType;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.locationtech.jts.geom.Geometry;
import org.xml.sax.helpers.NamespaceSupport;

public class SelectionTemplateVisitorTest {
    private SimpleFeatureType simpleFeatureType;
    private FileSystemResourceStore store;

    @Before
    public void setup() {
        this.store = new FileSystemResourceStore(new File("src/test/resources/org/geoserver/featurestemplating/builders/visitors"));
        SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
        tb.add("geometry", Geometry.class);
        tb.add("one", String.class);
        tb.add("b", String.class);
        tb.add("c", String.class);
        tb.add("e", String.class);
        tb.add("four", String.class);
        tb.add("five", String.class);
        tb.setName("testFeatureType");
        SimpleFeatureType schema = tb.buildFeatureType();
        schema.getDescriptor("b").getUserData().put("org.geotools.jdbc.nativeTypeName", "json");
        schema.getDescriptor("c").getUserData().put("org.geotools.jdbc.nativeTypeName", "json");
        schema.getDescriptor("e").getUserData().put("org.geotools.jdbc.nativeTypeName", "json");
        this.simpleFeatureType = schema;
    }

    @Test
    public void testPropertySelectionVisitor() throws IOException {
        PropertySelectionHandler propertySelectionHandler = this.handler();
        RootBuilder root = this.getBuilderTree("testTemplate.json");
        PropertySelectionVisitor visitor = new PropertySelectionVisitor(propertySelectionHandler, (PropertyType)this.simpleFeatureType);
        root = (RootBuilder)root.accept((TemplateVisitor)visitor, null);
        List children = root.getChildren();
        TemplateBuilder builder = (TemplateBuilder)children.get(0);
        builder = (TemplateBuilder)builder.getChildren().get(0);
        TemplateBuilder geom = (TemplateBuilder)builder.getChildren().get(0);
        Assert.assertEquals((Object)"geometry", (Object)((AbstractTemplateBuilder)geom).getKey(null));
        builder = (TemplateBuilder)builder.getChildren().get(1);
        Assert.assertEquals((Object)"properties", (Object)((AbstractTemplateBuilder)builder).getKey(null));
        for (TemplateBuilder child : builder.getChildren()) {
            AbstractTemplateBuilder abstractBuilder = (AbstractTemplateBuilder)child;
            String key = abstractBuilder.getKey(null);
            if ("one".equals(key)) {
                Assert.assertTrue((boolean)(child instanceof DynamicValueBuilder));
            }
            if ("b".equals(key)) {
                Assert.assertTrue((boolean)(child instanceof DynamicPropertySelection));
            } else if ("three".equals(key)) {
                TemplateBuilder composite = (TemplateBuilder)abstractBuilder.getChildren().get(0);
                Assert.assertEquals((long)1L, (long)composite.getChildren().size());
                Assert.assertTrue((boolean)(composite.getChildren().get(0) instanceof IncludeFlatPropertySelection));
            }
            Assert.assertNotEquals((Object)"two", (Object)key);
        }
        Set props = visitor.getQueryProperties();
        List<String> expected = Arrays.asList("geometry", "one", "b", "c");
        Assert.assertEquals((long)expected.size(), (long)props.size());
        Assert.assertTrue((boolean)props.containsAll(expected));
    }

    @Test
    public void testPropertySelectionWithMerge() throws IOException {
        PropertySelectionHandler propertySelectionHandler = this.handler();
        RootBuilder root = this.getBuilderTree("testTemplateOvr.json");
        PropertySelectionVisitor visitor = new PropertySelectionVisitor(propertySelectionHandler, (PropertyType)this.simpleFeatureType);
        root = (RootBuilder)root.accept((TemplateVisitor)visitor, null);
        List children = root.getChildren();
        TemplateBuilder builder = (TemplateBuilder)((TemplateBuilder)((TemplateBuilder)children.get(0)).getChildren().get(0)).getChildren().get(1);
        Assert.assertEquals((long)6L, (long)builder.getChildren().size());
        for (TemplateBuilder child : builder.getChildren()) {
            AbstractTemplateBuilder abstractBuilder = (AbstractTemplateBuilder)child;
            String key = abstractBuilder.getKey(null);
            if ("b".equals(key)) {
                Assert.assertTrue((boolean)(child instanceof DynamicPropertySelection));
                continue;
            }
            if ("e".equals(key)) {
                Assert.assertTrue((boolean)(child instanceof MergePropertySelection));
                continue;
            }
            if (key == null) {
                Assert.assertTrue((boolean)(child instanceof StaticPropertySelection));
                continue;
            }
            if ("d".equals(key)) {
                Assert.assertTrue((boolean)(child instanceof StaticPropertySelection));
                continue;
            }
            if ("three".equals(key)) {
                TemplateBuilder composite = (TemplateBuilder)child.getChildren().get(0);
                Assert.assertEquals((long)1L, (long)composite.getChildren().size());
                Assert.assertTrue((boolean)(composite.getChildren().get(0) instanceof IncludeFlatPropertySelection));
                continue;
            }
            Assert.assertTrue((boolean)(child instanceof StaticBuilder));
        }
        Set props = visitor.getQueryProperties();
        List<String> expected = Arrays.asList("b", "c", "d", "e", "one", "geometry");
        Assert.assertEquals((long)expected.size(), (long)props.size());
        Assert.assertTrue((boolean)props.containsAll(expected));
    }

    @Test
    public void testPropertySelectionRootDynamicIncludeFlat() throws IOException {
        PropertySelectionHandler propertySelectionHandler = this.handler();
        RootBuilder root = this.getBuilderTree("testTemplateOvr2.json");
        PropertySelectionVisitor visitor = new PropertySelectionVisitor(propertySelectionHandler, (PropertyType)this.simpleFeatureType);
        root = (RootBuilder)root.accept((TemplateVisitor)visitor, null);
        List children = root.getChildren();
        TemplateBuilder builder = (TemplateBuilder)((TemplateBuilder)children.get(0)).getChildren().get(0);
        Assert.assertEquals((long)1L, (long)builder.getChildren().size());
        Assert.assertTrue((boolean)(builder.getChildren().get(0) instanceof IncludeFlatPropertySelection));
        List<String> expected = Arrays.asList("b", "one", "geometry", "five", "e");
        Assert.assertEquals((long)expected.size(), (long)visitor.getQueryProperties().size());
        Assert.assertTrue((boolean)visitor.getQueryProperties().containsAll(expected));
    }

    private PropertySelectionHandler handler() {
        AbstractPropertySelection propertySelectionHandler = new AbstractPropertySelection(){

            public boolean hasSelectableJsonValue(AbstractTemplateBuilder builder) {
                return "b".equals(builder.getKey(null));
            }

            protected boolean isKeySelected(String key) {
                return key == null || !key.contains("two") && !key.contains("a") && !key.contains("four") && !key.contains("five");
            }
        };
        return propertySelectionHandler;
    }

    private RootBuilder getBuilderTree(String resourceName) throws IOException {
        Resource resource = this.store.get(resourceName);
        RecursiveJSONParser parser = new RecursiveJSONParser(resource);
        parser.parse();
        JSONTemplateReader templateReader = new JSONTemplateReader(parser.parse(), new TemplateReaderConfiguration(new NamespaceSupport()), parser.getWatchers());
        return templateReader.getRootBuilder();
    }
}

