/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.featurestemplating.builders.impl;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import net.sf.json.JSONArray;
import net.sf.json.JSONNull;
import net.sf.json.JSONObject;
import net.sf.json.JSONSerializer;
import org.geoserver.featurestemplating.builders.impl.DynamicValueBuilder;
import org.geoserver.featurestemplating.builders.impl.TemplateBuilderContext;
import org.geoserver.featurestemplating.configuration.TemplateIdentifier;
import org.geoserver.featurestemplating.writers.GMLTemplateWriter;
import org.geoserver.featurestemplating.writers.GeoJSONWriter;
import org.geoserver.featurestemplating.writers.TemplateOutputWriter;
import org.geotools.api.feature.Attribute;
import org.geotools.api.feature.Feature;
import org.geotools.api.feature.Property;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.AttributeDescriptor;
import org.geotools.api.feature.type.FeatureType;
import org.geotools.api.feature.type.PropertyDescriptor;
import org.geotools.data.DataTestCase;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.AttributeBuilder;
import org.geotools.feature.AttributeTypeBuilder;
import org.geotools.feature.ComplexFeatureBuilder;
import org.geotools.feature.TypeBuilder;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.xml.sax.helpers.NamespaceSupport;

public class DynamicValueBuilderTest
extends DataTestCase {
    private static final String JSON_PAYLOAD = "{ \"a\": 1, \"b\": [1, 2, 3]}";
    private SimpleFeature jsonFieldSimpleFeature;
    private Feature jsonFieldComplexFeature;

    @Before
    public void setupJSONFieldSimpleFeature() {
        SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
        tb.userData((Object)"org.geotools.jdbc.nativeTypeName", (Object)"json");
        tb.add("jf", String.class);
        tb.setName("jsonFieldSimpleType");
        SimpleFeatureType schema = tb.buildFeatureType();
        SimpleFeatureBuilder fb = new SimpleFeatureBuilder(schema);
        fb.add((Object)JSON_PAYLOAD);
        this.jsonFieldSimpleFeature = fb.buildFeature("jsonFieldSimpleType.1");
    }

    public List<SimpleFeature> setFeaturesWithNullable() {
        SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
        tb.add("nullAttribute", String.class);
        tb.setName("nullType");
        SimpleFeatureType schema = tb.buildFeatureType();
        SimpleFeatureBuilder fb = new SimpleFeatureBuilder(schema);
        fb.add(null);
        SimpleFeature f1 = fb.buildFeature("nullType.1");
        fb.add((Object)"notNullValue");
        SimpleFeature f2 = fb.buildFeature("nullType.2");
        return Arrays.asList(f1, f2);
    }

    @Before
    public void setupJSONFieldComplexFeature() {
        TypeBuilder typeBuilder = new TypeBuilder(CommonFactoryFinder.getFeatureTypeFactory(null));
        AttributeTypeBuilder atb = new AttributeTypeBuilder();
        atb.name("jf");
        atb.setBinding(String.class);
        atb.userData((Object)"org.geotools.jdbc.nativeTypeName", (Object)"json");
        AttributeDescriptor ad = atb.buildDescriptor("jf");
        typeBuilder.add((PropertyDescriptor)ad);
        typeBuilder.setName("jsonFieldComplexType");
        FeatureType schema = typeBuilder.feature();
        ComplexFeatureBuilder fb = new ComplexFeatureBuilder(schema);
        AttributeBuilder ab = new AttributeBuilder(CommonFactoryFinder.getFeatureFactory(null));
        ab.setDescriptor(ad);
        Attribute attribute = ab.buildSimple(null, (Object)JSON_PAYLOAD);
        fb.append(ad.getName(), (Property)attribute);
        this.jsonFieldComplexFeature = fb.buildFeature("jsonFieldComplexType.1");
    }

    @Test
    public void testEncodePath() throws IOException {
        JSONObject json = this.encodeDynamic("${id}", (Feature)this.roadFeatures[0]);
        Assert.assertEquals((long)1L, (long)json.size());
        Assert.assertEquals((Object)"1", (Object)json.getString("key"));
    }

    @Test
    public void testEncodeNullPath() throws IOException {
        JSONObject json = this.encodeDynamic("${missingAttribute}", (Feature)this.roadFeatures[0]);
        Assert.assertTrue((boolean)json.isEmpty());
    }

    @Test
    public void testEncodeNullCQL() throws IOException {
        JSONObject json = this.encodeDynamic("${a + b}", (Feature)this.roadFeatures[0]);
        Assert.assertTrue((boolean)json.isEmpty());
    }

    @Test
    public void testJSONXPathSimpleFeature() throws Exception {
        JSONObject json = this.encodeDynamic("${jf}", (Feature)this.jsonFieldSimpleFeature);
        JSONObject obj = json.getJSONObject("key");
        Assert.assertEquals((long)1L, (long)obj.getInt("a"));
        Assert.assertEquals(Arrays.asList(1, 2, 3), (Object)obj.getJSONArray("b"));
    }

    @Test
    public void testJSONXPathEncodeNull() throws Exception {
        List<SimpleFeature> features = this.setFeaturesWithNullable();
        JSONObject json = this.encodeDynamic("${nullAttribute}!", (Feature)features.get(0));
        Assert.assertTrue((boolean)(json.get("key") instanceof JSONNull));
        json = this.encodeDynamic("${nullAttribute}!", (Feature)features.get(1));
        Assert.assertEquals((Object)json.getString("key"), (Object)"notNullValue");
    }

    @Test
    public void testXMLXPathEncodeNull() throws Exception {
        List<SimpleFeature> features = this.setFeaturesWithNullable();
        String xml = this.encodeXML("${nullAttribute}!", (Feature)features.get(0));
        Assert.assertEquals((Object)xml, (Object)"<key></key>");
        xml = this.encodeXML("${nullAttribute}!", (Feature)features.get(1));
        Assert.assertEquals((Object)xml, (Object)"<key>notNullValue</key>");
    }

    @Test
    public void testJSONXPathComplexFeature() throws Exception {
        JSONObject json = this.encodeDynamic("${jf}", this.jsonFieldComplexFeature);
        JSONObject obj = json.getJSONObject("key");
        Assert.assertEquals((long)1L, (long)obj.getInt("a"));
        Assert.assertEquals(Arrays.asList(1, 2, 3), (Object)obj.getJSONArray("b"));
    }

    @Test
    public void testJSONCQLSimpleFeature() throws Exception {
        JSONObject json = this.encodeDynamic("$${jf}", (Feature)this.jsonFieldSimpleFeature);
        JSONObject obj = json.getJSONObject("key");
        Assert.assertEquals((long)1L, (long)obj.getInt("a"));
        Assert.assertEquals(Arrays.asList(1, 2, 3), (Object)obj.getJSONArray("b"));
    }

    @Test
    public void testJSONCQLComplexFeature() throws Exception {
        JSONObject json = this.encodeDynamic("$${jf}", this.jsonFieldComplexFeature);
        JSONObject obj = json.getJSONObject("key");
        Assert.assertEquals((long)1L, (long)obj.getInt("a"));
        Assert.assertEquals(Arrays.asList(1, 2, 3), (Object)obj.getJSONArray("b"));
    }

    @Test
    public void testJSONPointer() throws Exception {
        JSONObject json = this.encodeDynamic("$${jsonPointer(jf, '/b')}", this.jsonFieldComplexFeature);
        JSONArray obj = json.getJSONArray("key");
        Assert.assertEquals(Arrays.asList(1, 2, 3), (Object)obj);
    }

    private JSONObject encodeDynamic(String expression, Feature feature) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        GeoJSONWriter writer = new GeoJSONWriter(new JsonFactory().createGenerator((OutputStream)baos, JsonEncoding.UTF8), TemplateIdentifier.JSON);
        DynamicValueBuilder builder = new DynamicValueBuilder("key", expression, new NamespaceSupport());
        writer.writeStartObject();
        builder.evaluate((TemplateOutputWriter)writer, new TemplateBuilderContext((Object)feature));
        writer.writeEndObject();
        writer.close();
        String jsonString = new String(baos.toByteArray());
        return (JSONObject)JSONSerializer.toJSON((Object)jsonString);
    }

    private String encodeXML(String expression, Feature feature) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        GMLTemplateWriter outputWriter = this.getGmlWriter(TemplateIdentifier.GML31, baos);
        DynamicValueBuilder builder = new DynamicValueBuilder("key", expression, new NamespaceSupport());
        builder.evaluate((TemplateOutputWriter)outputWriter, new TemplateBuilderContext((Object)feature));
        outputWriter.close();
        return new String(baos.toByteArray());
    }

    private GMLTemplateWriter getGmlWriter(TemplateIdentifier identifier, OutputStream out) throws XMLStreamException {
        XMLOutputFactory xMLOutputFactory = XMLOutputFactory.newInstance();
        XMLStreamWriter xMLStreamWriter = xMLOutputFactory.createXMLStreamWriter(out);
        GMLTemplateWriter outputWriter = new GMLTemplateWriter(xMLStreamWriter, identifier.getOutputFormat());
        outputWriter.addNamespaces(new HashMap());
        return outputWriter;
    }
}

