/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.dggs.rhealpix;

import java.awt.Color;
import java.util.List;
import java.util.Objects;
import jep.JepException;
import jep.SharedInterpreter;
import org.geotools.dggs.Zone;
import org.geotools.dggs.ZoneWrapper;
import org.geotools.dggs.rhealpix.RHealPixDGGSInstance;
import org.geotools.dggs.rhealpix.RHealPixUtils;
import org.geotools.util.Converters;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.CoordinateSequenceFactory;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;

public class RHealPixZone
implements Zone {
    private final String id;
    private final RHealPixDGGSInstance dggs;
    private Polygon boundary;

    public RHealPixZone(RHealPixDGGSInstance dggs, String id) {
        this.dggs = dggs;
        this.id = id;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public int getResolution() {
        return this.id.length() - 1;
    }

    @Override
    public Point getCenter() {
        return this.dggs.runtime.runSafe(interpreter -> {
            RHealPixUtils.setCellId(interpreter, "id", this.id);
            interpreter.exec("c = Cell(dggs, id)");
            double[] points = (double[])interpreter.getValue("c.centroid(False)", double[].class);
            return this.dggs.gf.createPoint(new Coordinate(points[0], points[1]));
        });
    }

    @Override
    public Polygon getBoundary() {
        if (this.boundary == null) {
            this.boundary = this.dggs.runtime.runSafe(interpreter -> {
                RHealPixUtils.setCellId(interpreter, "id", this.id);
                interpreter.exec("c = Cell(dggs, id)");
                double[][] vertices = this.getShape().getVertices(interpreter);
                return this.getPolygon(vertices);
            }, e -> new RuntimeException("Failed to compute boundary for " + this.id, e));
        }
        return this.boundary;
    }

    @Override
    public Object getExtraProperty(String name) {
        if ("shape".equals(name)) {
            return this.dggs.runtime.runSafe(si -> {
                RHealPixUtils.setCellId(si, "id", this.id);
                si.exec("c = Cell(dggs, id)");
                return (String)si.getValue("c.ellipsoidal_shape()", String.class);
            });
        }
        if ("color".equals(name)) {
            return this.dggs.runtime.runSafe(si -> {
                RHealPixUtils.setCellId(si, "id", this.id);
                si.exec("c = Cell(dggs, id)");
                List definition = (List)si.getValue("c.color()", List.class);
                int red = (int)Math.round(((Number)definition.get(0)).doubleValue() * 255.0);
                int green = (int)Math.round(((Number)definition.get(1)).doubleValue() * 255.0);
                int blue = (int)Math.round(((Number)definition.get(2)).doubleValue() * 255.0);
                return (String)Converters.convert((Object)new Color(red, green, blue), String.class);
            });
        }
        throw new IllegalArgumentException("Invalid extra property value " + name);
    }

    private CellType getShape() {
        return this.dggs.runtime.runSafe(si -> CellType.valueOf((String)si.getValue("c.ellipsoidal_shape()", String.class)));
    }

    private Polygon getPolygon(double[][] vertices) {
        CoordinateSequence cs;
        CoordinateSequenceFactory csf = this.dggs.gf.getCoordinateSequenceFactory();
        if (this.dggs.northPoleZones.contains(this.id)) {
            double latitude = vertices[0][1];
            cs = this.buildRectangle(csf, -180.0, latitude, 180.0, 90.0);
        } else if (this.dggs.southPoleZones.contains(this.id)) {
            double latitude = vertices[0][1];
            cs = this.buildRectangle(csf, -180.0, -90.0, 180.0, latitude);
        } else {
            int size = vertices.length;
            cs = csf.create(size + 1, 2);
            for (int i = 0; i < size; ++i) {
                cs.setOrdinate(i, 0, vertices[i][0]);
                cs.setOrdinate(i, 1, vertices[i][1]);
            }
            cs.setOrdinate(size, 0, vertices[0][0]);
            cs.setOrdinate(size, 1, vertices[0][1]);
            cs = ZoneWrapper.wrap(cs);
        }
        LinearRing ring = this.dggs.gf.createLinearRing(cs);
        return this.dggs.gf.createPolygon(ring);
    }

    public CoordinateSequence buildRectangle(CoordinateSequenceFactory csf, double minX, double minY, double maxX, double maxY) {
        CoordinateSequence cs = csf.create(5, 2);
        cs.setOrdinate(0, 0, minX);
        cs.setOrdinate(0, 1, minY);
        cs.setOrdinate(1, 0, minX);
        cs.setOrdinate(1, 1, maxY);
        cs.setOrdinate(2, 0, maxX);
        cs.setOrdinate(2, 1, maxY);
        cs.setOrdinate(3, 0, maxX);
        cs.setOrdinate(3, 1, minY);
        cs.setOrdinate(4, 0, minX);
        cs.setOrdinate(4, 1, minY);
        return cs;
    }

    public String toString() {
        return "RHealPixZone{id='" + this.id + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RHealPixZone that = (RHealPixZone)o;
        return Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    static enum CellType {
        quad,
        cap,
        dart(null, "c.boundary(10, False)"),
        skew_quad(null, "c.boundary(10, False)");

        String setupScript = null;
        String verticesScript = "c.vertices(False)";

        private CellType() {
        }

        private CellType(String setupScript, String verticesScript) {
            this.setupScript = setupScript;
            this.verticesScript = verticesScript;
        }

        public double[][] getVertices(SharedInterpreter interpreter) throws JepException {
            if (this.setupScript != null) {
                interpreter.exec(this.setupScript);
            }
            return (double[][])interpreter.getValue(this.verticesScript, double[][].class);
        }
    }
}

