/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.dggs.gstore;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.commons.collections4.iterators.SingletonIterator;
import org.geotools.api.data.FeatureReader;
import org.geotools.api.data.Query;
import org.geotools.api.feature.FeatureVisitor;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.AttributeDescriptor;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterVisitor;
import org.geotools.api.filter.PropertyIsEqualTo;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.Literal;
import org.geotools.api.filter.expression.PropertyName;
import org.geotools.api.filter.sort.SortBy;
import org.geotools.api.filter.spatial.BBOX;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.data.DataUtilities;
import org.geotools.data.FilteringFeatureReader;
import org.geotools.data.ReTypeFeatureReader;
import org.geotools.data.simple.EmptySimpleFeatureReader;
import org.geotools.data.sort.SortedFeatureReader;
import org.geotools.data.store.ContentEntry;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.data.store.EmptyIterator;
import org.geotools.dggs.DGGSFilterVisitor;
import org.geotools.dggs.DGGSInstance;
import org.geotools.dggs.DGGSSetFunction;
import org.geotools.dggs.Zone;
import org.geotools.dggs.gstore.DGGSFeatureSource;
import org.geotools.dggs.gstore.DGGSGeometryStore;
import org.geotools.dggs.gstore.DGGSResolutionCalculator;
import org.geotools.dggs.gstore.ZonesFeatureIterator;
import org.geotools.feature.FeatureTypes;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.feature.visitor.FeatureAttributeVisitor;
import org.geotools.feature.visitor.MaxVisitor;
import org.geotools.feature.visitor.MinVisitor;
import org.geotools.feature.visitor.UniqueVisitor;
import org.geotools.filter.FilterAttributeExtractor;
import org.geotools.filter.visitor.ExtractBoundsFilterVisitor;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.util.factory.Hints;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;

class DGGSGeometryFeatureSource
extends ContentFeatureSource
implements DGGSFeatureSource {
    static final Logger LOGGER = Logging.getLogger(DGGSGeometryFeatureSource.class);
    private final DGGSGeometryStore store;
    private DGGSResolutionCalculator resolutions;

    public DGGSGeometryFeatureSource(ContentEntry entry, DGGSGeometryStore store) {
        super(entry, Query.ALL);
        this.store = store;
        this.resolutions = store.resolutions;
    }

    protected ReferencedEnvelope getBoundsInternal(Query query) throws IOException {
        if (query == Query.ALL || query == null || query.getFilter() == Filter.INCLUDE || query.getFilter() == null) {
            return DGGSInstance.WORLD;
        }
        return null;
    }

    protected int getCountInternal(Query query) throws IOException {
        Envelope bounds = this.getFilterBounds(query.getFilter());
        if (bounds.isNull()) {
            return 0;
        }
        int targetResolution = this.resolutions.getTargetResolution(query, 0);
        if (!this.resolutions.isValid(targetResolution)) {
            return 0;
        }
        Filter filter = query.getFilter();
        if (filter == null || filter == Filter.INCLUDE || filter instanceof BBOX) {
            long count = this.store.dggs.countZonesFromEnvelope(bounds, targetResolution);
            if (count > Integer.MAX_VALUE) {
                LOGGER.warning("Count exceeds integer range, returning MAXINT");
                return Integer.MAX_VALUE;
            }
            return (int)count;
        }
        return -1;
    }

    private Envelope getFilterBounds(Filter filter) {
        Envelope bounds = (Envelope)filter.accept((FilterVisitor)ExtractBoundsFilterVisitor.BOUNDS_VISITOR, null);
        if (bounds == null) {
            bounds = DGGSInstance.WORLD;
        }
        return bounds;
    }

    protected boolean canSort(Query q) {
        return true;
    }

    protected boolean canFilter(Query q) {
        return true;
    }

    protected FeatureReader<SimpleFeatureType, SimpleFeature> getReaderInternal(Query originalQuery) throws IOException {
        SortBy[] sortBy;
        SimpleFeatureType readSchema = this.getReadSchema(this.query);
        Query query = this.injectDGGS(originalQuery);
        Iterator<Zone> iterator = this.getZoneIterator(query);
        if (iterator == null) {
            return new EmptySimpleFeatureReader(readSchema);
        }
        SimpleFeatureType resultSchema = this.getResultSchema(query);
        ZonesFeatureIterator reader = new ZonesFeatureIterator(iterator, readSchema, this.store.dggs.getExtraProperties());
        Filter filter = query.getFilter();
        if (filter != null && !Filter.INCLUDE.equals(filter)) {
            reader = new FilteringFeatureReader((FeatureReader)reader, filter);
        }
        if ((sortBy = query.getSortBy()) != null && sortBy.length != 0 && sortBy != SortBy.UNSORTED && (sortBy.length != 1 || sortBy[0] != SortBy.NATURAL_ORDER)) {
            reader = new SortedFeatureReader(DataUtilities.simple((FeatureReader)reader), query);
        }
        if (!FeatureTypes.equals((SimpleFeatureType)readSchema, (SimpleFeatureType)resultSchema)) {
            reader = new ReTypeFeatureReader((FeatureReader)reader, resultSchema);
        }
        return reader;
    }

    SimpleFeatureType getResultSchema(Query q) {
        if (q.getPropertyNames() == null) {
            return this.getSchema();
        }
        return SimpleFeatureTypeBuilder.retype((SimpleFeatureType)this.getSchema(), (String[])q.getPropertyNames());
    }

    SimpleFeatureType getReadSchema(Query q) {
        if (q.getPropertyNames() == Query.ALL_NAMES) {
            return this.getSchema();
        }
        LinkedHashSet<String> attributes = new LinkedHashSet<String>();
        attributes.addAll(Arrays.asList(q.getPropertyNames()));
        Filter filter = q.getFilter();
        if (filter != null && !Filter.INCLUDE.equals(filter)) {
            FilterAttributeExtractor fat = new FilterAttributeExtractor(this.getSchema());
            filter.accept((FilterVisitor)fat, null);
            attributes.addAll(fat.getAttributeNameSet());
        }
        if (q.getSortBy() != null && q.getSortBy().length > 0) {
            for (SortBy sort : q.getSortBy()) {
                if (sort.getPropertyName() == null) continue;
                attributes.add(sort.getPropertyName().getPropertyName());
            }
        }
        return SimpleFeatureTypeBuilder.retype((SimpleFeatureType)this.getSchema(), new ArrayList(attributes));
    }

    private Query injectDGGS(Query originalQuery) {
        Filter originalFilter = originalQuery.getFilter();
        Filter filter = (Filter)originalFilter.accept((FilterVisitor)new DGGSFilterVisitor(this.store.dggs), null);
        Query query = new Query(originalQuery);
        query.setFilter(filter);
        return query;
    }

    private Iterator<Zone> getZoneIterator(Query query) {
        Filter filter = query.getFilter();
        if (filter instanceof PropertyIsEqualTo) {
            PropertyIsEqualTo pe = (PropertyIsEqualTo)filter;
            Expression ex1 = pe.getExpression1();
            Expression ex2 = pe.getExpression2();
            if (ex1 instanceof DGGSSetFunction && ((DGGSSetFunction)ex1).isStable()) {
                query.setFilter((Filter)Filter.INCLUDE);
                return ((DGGSSetFunction)ex1).getMatchedZones();
            }
            if (ex1 instanceof PropertyName && ((PropertyName)ex1).getPropertyName().equals("zoneId") && ex2 instanceof Literal) {
                query.setFilter((Filter)Filter.INCLUDE);
                Zone zone = this.store.dggs.getZone((String)ex2.evaluate(null, String.class));
                if (zone == null) {
                    return new EmptyIterator();
                }
                return new SingletonIterator((Object)zone);
            }
        }
        return this.getIteratorFromEnvelope(query);
    }

    private Iterator<Zone> getIteratorFromEnvelope(Query query) {
        Envelope bounds = this.getFilterBounds(query.getFilter());
        if (bounds.isNull()) {
            return null;
        }
        int targetResolution = this.resolutions.getTargetResolution(query, 0);
        if (!this.store.resolutions.isValid(targetResolution)) {
            return null;
        }
        if (query.getFilter() instanceof BBOX) {
            query.setFilter((Filter)Filter.INCLUDE);
        }
        return this.store.dggs.zonesFromEnvelope(bounds, targetResolution, false);
    }

    protected SimpleFeatureType buildFeatureType() throws IOException {
        SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
        tb.setName(this.entry.getName());
        tb.add("zoneId", String.class);
        tb.userData((Object)"dggsInstrisic", (Object)true);
        tb.add("resolution", Integer.class);
        tb.userData((Object)"dggsInstrisic", (Object)true);
        tb.add("geometry", Geometry.class, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        this.store.dggs.getExtraProperties().forEach(ad -> tb.add(ad));
        return tb.buildFeatureType();
    }

    protected void addHints(Set<Hints.Key> hints) {
        hints.add(Hints.GEOMETRY_DISTANCE);
    }

    @Override
    public DGGSInstance getDGGS() {
        return this.store.dggs;
    }

    protected boolean canRetype(Query q) {
        return true;
    }

    protected boolean handleVisitor(Query query, FeatureVisitor visitor) throws IOException {
        FeatureAttributeVisitor fav;
        Set<String> attributes;
        if (visitor instanceof FeatureAttributeVisitor && (attributes = this.getAttributeSet(fav = (FeatureAttributeVisitor)visitor)) != null && attributes.equals(Collections.singleton("resolution"))) {
            int[] resolutions = this.getDGGS().getResolutions();
            if (fav instanceof MinVisitor) {
                ((MinVisitor)fav).setValue((Object)resolutions[0]);
                return true;
            }
            if (fav instanceof MaxVisitor) {
                ((MaxVisitor)fav).setValue((Object)resolutions[resolutions.length - 1]);
                return true;
            }
            if (fav instanceof UniqueVisitor) {
                List rl = Arrays.stream(resolutions).mapToObj(v -> v).collect(Collectors.toList());
                ((UniqueVisitor)fav).setValue(rl);
                return true;
            }
        }
        return super.handleVisitor(query, visitor);
    }

    private Set<String> getAttributeSet(FeatureAttributeVisitor fav) {
        HashSet<String> result = new HashSet<String>();
        for (Expression ex : fav.getExpressions()) {
            AttributeDescriptor ad = (AttributeDescriptor)ex.evaluate((Object)this.getSchema(), AttributeDescriptor.class);
            if (ad == null) {
                return null;
            }
            result.add(ad.getLocalName());
        }
        return result;
    }
}

