/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.dggs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineSegment;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.precision.GeometryPrecisionReducer;

public class ZoneWrapper {
    private static final double EPS_AREA = 1.0E-12;

    public static CoordinateSequence wrap(CoordinateSequence cs) {
        DatelineLocation location = ZoneWrapper.isDatelineCrossing(cs);
        if (location != DatelineLocation.NotCrossing) {
            int size = cs.size();
            for (int i = 0; i < size; ++i) {
                double lng = cs.getOrdinate(i, 0);
                double offset = ZoneWrapper.getOffset(location, lng);
                if (offset == 0.0) continue;
                cs.setOrdinate(i, 0, lng + offset);
            }
        }
        return cs;
    }

    public static CoordinateSequence includePole(GeometryFactory gf, CoordinateSequence cs, boolean north) {
        ArrayList<Coordinate> coordinates = new ArrayList<Coordinate>(Arrays.asList(cs.toCoordinateArray()));
        Collections.sort(coordinates, (o1, o2) -> (int)Math.signum(o1.x - o2.x));
        Coordinate low = (Coordinate)coordinates.get(0);
        Coordinate high = (Coordinate)coordinates.get(coordinates.size() - 1);
        if (low.x > -180.0 || high.x < 180.0) {
            if (low.x > -180.0) {
                Coordinate shifted = new Coordinate(high.x - 360.0, high.y);
                LineSegment missingPortion = new LineSegment(shifted, low);
                LineSegment dateline = new LineSegment(new Coordinate(-180.0, -90.0), new Coordinate(-180.0, 90.0));
                Coordinate intersection = missingPortion.intersection(dateline);
                coordinates.add(0, intersection);
                if (high.x < 180.0) {
                    coordinates.add(coordinates.size(), new Coordinate(180.0, intersection.y));
                }
            } else {
                coordinates.add(coordinates.size() - 1, new Coordinate(180.0, low.y));
            }
        }
        double poleLatitude = north ? 90.0 : -90.0;
        int cl = coordinates.size();
        coordinates.add(cl, new Coordinate(180.0, poleLatitude));
        coordinates.add(cl + 1, new Coordinate(-180.0, poleLatitude));
        coordinates.add(cl + 2, new Coordinate(-180.0, ((Coordinate)coordinates.get((int)0)).y));
        return gf.getCoordinateSequenceFactory().create(coordinates.toArray(new Coordinate[coordinates.size()]));
    }

    public static CoordinateSequence getUnionSequence(GeometryFactory gf, CoordinateSequence cs, Polygon polarPoly) {
        CoordinateSequence csUnion;
        Polygon poly = gf.createPolygon(cs);
        if (poly.getArea() < 1.0E-12) {
            csUnion = polarPoly.getExteriorRing().getCoordinateSequence();
        } else {
            Geometry union = ZoneWrapper.union(polarPoly, poly);
            csUnion = ((Polygon)union.getGeometryN(0)).getExteriorRing().getCoordinateSequence();
        }
        return gf.getCoordinateSequenceFactory().create(csUnion);
    }

    public static Geometry union(Polygon polarPoly, Polygon poly) {
        Geometry result;
        block5: {
            result = null;
            try {
                result = polarPoly.union((Geometry)poly);
            }
            catch (Exception e1) {
                double precision = 1.0E-8;
                for (int i = 0; i < 6; ++i) {
                    GeometryPrecisionReducer reducer = new GeometryPrecisionReducer(new PrecisionModel(1.0 / precision));
                    Geometry reducedPolarPoly = reducer.reduce((Geometry)polarPoly);
                    Geometry reducedPoly = reducer.reduce((Geometry)poly);
                    try {
                        result = reducedPolarPoly.union(reducedPoly);
                        break;
                    }
                    catch (Exception e3) {
                        precision *= 10.0;
                        continue;
                    }
                }
                if (result != null) break block5;
                throw new RuntimeException("Failed to union geometries, even with precision reduction");
            }
        }
        return result;
    }

    public static DatelineLocation isDatelineCrossing(CoordinateSequence cs) {
        int eastCount = 0;
        int westCount = 0;
        boolean datelineCrossing = false;
        int size = cs.size();
        double prevLng = cs.getX(0);
        for (int i = 0; i < size - 1; ++i) {
            double lng = cs.getX(i);
            if (lng - prevLng > 180.0 || lng - prevLng < -180.0) {
                datelineCrossing = true;
            }
            if (lng < 0.0) {
                ++westCount;
            } else {
                ++eastCount;
            }
            prevLng = lng;
        }
        if (datelineCrossing) {
            return eastCount > westCount ? DatelineLocation.East : DatelineLocation.West;
        }
        return DatelineLocation.NotCrossing;
    }

    private static double getOffset(DatelineLocation location, double lng) {
        double offset = 0.0;
        if (location == DatelineLocation.East && lng < 0.0) {
            offset = 360.0;
        }
        if (location == DatelineLocation.West && lng > 0.0) {
            offset = -360.0;
        }
        return offset;
    }

    static interface AggregatePointSelector {
        public Coordinate select(Coordinate var1, Coordinate var2);
    }

    public static enum DatelineLocation {
        NotCrossing,
        West,
        East;

    }
}

