/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.dggs;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.geotools.api.feature.Feature;
import org.geotools.api.filter.expression.Expression;
import org.geotools.feature.visitor.AbstractCalcResult;
import org.geotools.feature.visitor.Aggregate;
import org.geotools.feature.visitor.CalcResult;
import org.geotools.feature.visitor.FeatureAttributeVisitor;
import org.geotools.feature.visitor.FeatureCalc;

public class MatrixAggregate
implements FeatureCalc,
FeatureAttributeVisitor {
    private final List<Aggregate> aggregates;
    private final List<Expression> variables;
    private final List<FeatureCalc> calculators = new ArrayList<FeatureCalc>();
    private MatrixAggregateResult result;

    public MatrixAggregate(List<Expression> variables, List<Aggregate> aggregates) {
        this.variables = variables;
        this.aggregates = aggregates;
        for (Expression variable : variables) {
            for (Aggregate aggregate : aggregates) {
                this.calculators.add(aggregate.create(variable));
            }
        }
    }

    public void setResults(List<Object> results) {
        if (results.size() != this.calculators.size()) {
            throw new IllegalArgumentException("Invalid results, size does not match expected: " + this.calculators.size());
        }
        ArrayList<CalcResult> resultList = new ArrayList<CalcResult>();
        Iterator<Object> iterator = results.iterator();
        for (Expression variable : this.variables) {
            for (Aggregate aggregate : this.aggregates) {
                resultList.add(aggregate.wrap(variable, iterator.next()));
            }
        }
        this.result = new MatrixAggregateResult(resultList);
    }

    public List<FeatureCalc> getCalculators() {
        return Collections.unmodifiableList(this.calculators);
    }

    public CalcResult getResult() {
        MatrixAggregateResult inMemoryResults = new MatrixAggregateResult(this.calculators.stream().map(c -> c.getResult()).collect(Collectors.toList()));
        if (this.result == null) {
            return inMemoryResults;
        }
        return inMemoryResults.merge((CalcResult)this.result);
    }

    public void visit(Feature feature) {
        for (FeatureCalc calc : this.calculators) {
            calc.visit(feature);
        }
    }

    public List<Expression> getExpressions() {
        return Collections.unmodifiableList(this.variables);
    }

    static class MatrixAggregateResult
    extends AbstractCalcResult {
        List<CalcResult> results;

        public MatrixAggregateResult(List<CalcResult> results) {
            this.results = results;
        }

        public Object getValue() {
            return this.results.stream().map(r -> r.getValue()).collect(Collectors.toList());
        }

        public CalcResult merge(CalcResult resultsToAdd) {
            if (!(resultsToAdd instanceof MatrixAggregateResult)) {
                throw new IllegalArgumentException("Cannot merge this result: " + resultsToAdd);
            }
            MatrixAggregateResult other = (MatrixAggregateResult)resultsToAdd;
            if (other.results.size() != this.results.size()) {
                throw new IllegalArgumentException("Size of the two calc results do not match, should be " + this.results.size());
            }
            ArrayList<CalcResult> merged = new ArrayList<CalcResult>();
            for (int i = 0; i < this.results.size(); ++i) {
                merged.add(this.results.get(i).merge(other.results.get(i)));
            }
            return new MatrixAggregateResult(merged);
        }
    }
}

