/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.dggs;

import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import org.geotools.api.filter.capability.FunctionName;
import org.geotools.dggs.DGGSInstance;
import org.geotools.dggs.DGGSSetFunctionBase;
import org.geotools.dggs.Zone;

public class ChildrenFunction
extends DGGSSetFunctionBase {
    Set<String> zoneIds;
    public static FunctionName NAME = ChildrenFunction.functionName((String)"children", (String)"result:Boolean", (String[])new String[]{"testedZoneId:String", "referenceZoneId:String", "resolution:Integer", "dggs:org.geotools.dggs.DGGSInstance"});

    public ChildrenFunction() {
        super(NAME);
    }

    public Object evaluate(Object object) {
        String testedZoneId = (String)this.getParameterValue(object, 0);
        if (testedZoneId == null) {
            return false;
        }
        return this.matches(testedZoneId, () -> {
            String referenceZoneId = (String)this.getParameterValue(object, 1);
            Integer resolution = (Integer)this.getParameterValue(object, 2);
            DGGSInstance dggs = (DGGSInstance)this.getParameterValue(object, 3);
            if (referenceZoneId == null || resolution == null || dggs == null) {
                return Collections.emptyIterator();
            }
            if (dggs.getZone(testedZoneId).getResolution() != resolution.intValue()) {
                return Collections.emptyIterator();
            }
            return dggs.children(referenceZoneId, resolution);
        });
    }

    @Override
    public Iterator<Zone> getMatchedZones() {
        if (!this.isStable()) {
            throw new IllegalStateException("Source parameters are not stable");
        }
        String referenceZoneId = (String)this.getParameterValue(null, 1);
        Integer resolution = (Integer)this.getParameterValue(null, 2);
        DGGSInstance dggs = (DGGSInstance)this.getParameterValue(null, 3);
        return dggs.children(referenceZoneId, resolution);
    }

    @Override
    public long countMatched() {
        if (!this.isStable()) {
            throw new IllegalStateException("Source parameters are not stable");
        }
        String referenceZoneId = (String)this.getParameterValue(null, 1);
        Integer resolution = (Integer)this.getParameterValue(null, 2);
        DGGSInstance dggs = (DGGSInstance)this.getParameterValue(null, 3);
        return dggs.countChildren(referenceZoneId, resolution);
    }
}

