/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.dggs.rhealpix;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Stack;
import java.util.function.Function;
import org.geotools.dggs.rhealpix.RHealPixDGGSInstance;
import org.geotools.dggs.rhealpix.RHealPixUtils;
import org.geotools.dggs.rhealpix.RHealPixZone;

class RHealPixZoneIterator<R>
implements Iterator<R> {
    private final RHealPixDGGSInstance rpix;
    Function<RHealPixZone, Boolean> drill;
    Function<RHealPixZone, Boolean> accept;
    Function<RHealPixZone, R> map;
    Stack<String> candidates = new Stack();
    R next = null;

    public RHealPixZoneIterator(RHealPixDGGSInstance rpix, Function<RHealPixZone, Boolean> drill, Function<RHealPixZone, Boolean> accept, Function<RHealPixZone, R> map) {
        this(rpix, drill, accept, map, rpix.runtime.runSafe(si -> (List)si.getValue("dggs.cells0", List.class)));
    }

    public RHealPixZoneIterator(RHealPixDGGSInstance rpix, Function<RHealPixZone, Boolean> drill, Function<RHealPixZone, Boolean> accept, Function<RHealPixZone, R> map, Collection<String> rootZones) {
        this.rpix = rpix;
        this.drill = drill;
        this.accept = accept;
        this.map = map;
        this.candidates.addAll(rootZones);
    }

    @Override
    public boolean hasNext() {
        while (this.next == null && !this.candidates.isEmpty()) {
            String test = String.valueOf(this.candidates.pop());
            RHealPixZone zone = this.rpix.getZone(test);
            if (this.accept.apply(zone).booleanValue()) {
                this.next = this.map.apply(zone);
                continue;
            }
            if (!this.drill.apply(zone).booleanValue()) continue;
            this.candidates.addAll(0, this.rpix.runtime.runSafe(si -> {
                RHealPixUtils.setCellId(si, "id", test);
                si.exec("c = Cell(dggs, id)");
                return (List)si.getValue("list(c.subcells())", List.class);
            }));
        }
        return this.next != null;
    }

    @Override
    public R next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        R result = this.next;
        this.next = null;
        return result;
    }
}

