/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.dggs.rhealpix;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Spliterators;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import jep.JepException;
import jep.SharedInterpreter;
import org.geotools.api.feature.type.AttributeDescriptor;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.expression.Expression;
import org.geotools.data.store.EmptyIterator;
import org.geotools.dggs.DGGSInstance;
import org.geotools.dggs.Zone;
import org.geotools.dggs.rhealpix.JEPWebRuntime;
import org.geotools.dggs.rhealpix.RHealPixParentIterator;
import org.geotools.dggs.rhealpix.RHealPixUtils;
import org.geotools.dggs.rhealpix.RHealPixZone;
import org.geotools.dggs.rhealpix.RHealPixZoneIterator;
import org.geotools.feature.AttributeTypeBuilder;
import org.geotools.filter.function.FilterFunction_offset;
import org.geotools.geometry.jts.JTS;
import org.geotools.util.SoftValueHashMap;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.CoordinateSequenceFilter;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.Polygonal;
import org.locationtech.jts.geom.prep.PreparedPolygon;
import org.locationtech.jts.operation.predicate.RectangleContains;
import org.locationtech.jts.operation.predicate.RectangleIntersects;

public class RHealPixDGGSInstance
implements DGGSInstance {
    static final Logger LOGGER = Logging.getLogger(RHealPixDGGSInstance.class);
    private final String identifier;
    final JEPWebRuntime runtime;
    final GeometryFactory gf = new GeometryFactory();
    final Set<String> northPoleZones;
    final Set<String> southPoleZones;
    final SoftValueHashMap<String, RHealPixZone> zoneCache = new SoftValueHashMap(10000);

    public RHealPixDGGSInstance(JEPWebRuntime runtime, String identifier) {
        this.runtime = runtime;
        this.identifier = identifier;
        int[] resolutions = this.getResolutions();
        this.northPoleZones = Arrays.stream(resolutions).mapToObj(r -> this.getZone(0.0, 90.0, r).getId()).collect(Collectors.toSet());
        this.southPoleZones = Arrays.stream(resolutions).mapToObj(r -> this.getZone(0.0, -90.0, r).getId()).collect(Collectors.toSet());
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    public void close() {
        this.runtime.dispose();
    }

    @Override
    public int[] getResolutions() {
        int[] result = new int[14];
        for (int i = 0; i < result.length; ++i) {
            result[i] = i;
        }
        return result;
    }

    @Override
    public RHealPixZone getZone(String id) {
        RHealPixZone zone = (RHealPixZone)this.zoneCache.get((Object)id);
        if (zone == null) {
            try {
                SharedInterpreter interpreter = this.runtime.getInterpreter();
                RHealPixUtils.setCellId(interpreter, "id", id);
                interpreter.exec("c = dggs.cell(id)");
                zone = new RHealPixZone(this, id);
                this.zoneCache.put((Object)id, (Object)zone);
            }
            catch (JepException e) {
                throw new IllegalArgumentException("Invalid zone identifier '" + id + "'", e);
            }
        }
        return zone;
    }

    @Override
    public Zone getZone(double lat, double lon, int resolution) {
        return this.runtime.runSafe(interpreter -> {
            interpreter.set("p", Arrays.asList(lat, lon));
            interpreter.set("r", (Object)resolution);
            interpreter.exec("c = dggs.cell_from_point(r, p, False)");
            List idList = (List)interpreter.getValue("c.suid", List.class);
            String id = this.toZoneId(idList);
            return new RHealPixZone(this, id);
        });
    }

    private String toZoneId(List<Object> idList) {
        String id = idList.stream().map(o -> String.valueOf(o)).collect(Collectors.joining(""));
        return id;
    }

    @Override
    public Iterator<Zone> zonesFromEnvelope(Envelope envelope, int targetResolution, boolean compact) {
        Envelope intersection = envelope.intersection((Envelope)WORLD);
        if (intersection.isNull()) {
            return new EmptyIterator();
        }
        if (compact) {
            ArrayList<String> identifiers = new ArrayList<String>();
            new RHealPixZoneIterator<String>(this, zone -> {
                int r = zone.getResolution();
                if (r >= targetResolution) {
                    return false;
                }
                Polygon boundary = zone.getBoundary();
                return this.overlaps(boundary, envelope, true) && !this.contained(boundary, envelope, true);
            }, zone -> {
                int r = zone.getResolution();
                Polygon boundary = zone.getBoundary();
                return r == targetResolution && this.overlaps(boundary, envelope, false) || r < targetResolution && this.contained(boundary, envelope, true);
            }, zone -> zone.getId()).forEachRemaining(id -> identifiers.add((String)id));
            this.compact(identifiers);
            return identifiers.stream().map(id -> new RHealPixZone(this, (String)id)).iterator();
        }
        return new RHealPixZoneIterator<Zone>(this, zone -> zone.getResolution() < targetResolution && this.overlaps(zone.getBoundary(), envelope, true), zone -> zone.getResolution() == targetResolution && this.overlaps(zone.getBoundary(), envelope, false), zone -> zone);
    }

    public void compact(List<String> identifiers) {
        Collections.sort(identifiers);
        for (int r = this.maxResolution(identifiers); r > 0 && this.compact(identifiers, r); --r) {
        }
    }

    private int maxResolution(List<String> identifiers) {
        return identifiers.stream().mapToInt(id -> id.length()).max().getAsInt() - 1;
    }

    boolean compact(List<String> identifiers, int resolution) {
        boolean compacted = false;
        String parent = null;
        int count = 0;
        for (int position = identifiers.size() - 1; position >= 0; --position) {
            String id = identifiers.get(position);
            if (id.length() - 1 != resolution) {
                parent = null;
                count = 0;
            }
            if (id.length() > 1) {
                String idParent = id.substring(0, id.length() - 1);
                if (parent == null || !idParent.equals(parent)) {
                    parent = idParent;
                    count = 1;
                    continue;
                }
                if (++count != 9) continue;
                for (int i = 1; i < 9; ++i) {
                    identifiers.remove(position + 1);
                }
                identifiers.set(position, parent);
                compacted = true;
                parent = null;
                count = 0;
                continue;
            }
            parent = null;
        }
        return compacted;
    }

    private boolean overlaps(Polygon polygon, Envelope envelope, boolean testAcrossDateline) {
        RectangleIntersects tester = new RectangleIntersects(JTS.toGeometry((Envelope)envelope));
        return this.testRelation(polygon, envelope, p -> tester.intersects((Geometry)p), testAcrossDateline);
    }

    private boolean contained(Polygon polygon, Envelope envelope, boolean testAcrossDateline) {
        RectangleContains tester = new RectangleContains(JTS.toGeometry((Envelope)envelope));
        return this.testRelation(polygon, envelope, p -> tester.contains((Geometry)p), testAcrossDateline);
    }

    private boolean testRelation(Polygon polygon, Envelope envelope, Function<Polygon, Boolean> relation, boolean testAcrossDateline) {
        if (relation.apply(polygon).booleanValue()) {
            return true;
        }
        if (!testAcrossDateline) {
            return false;
        }
        Polygon otherSide = this.flipDatelineSide(polygon);
        if (otherSide == null) {
            return false;
        }
        return relation.apply(otherSide);
    }

    private <T extends Geometry> T flipDatelineSide(T g) {
        Envelope polyEnvelope = g.getEnvelopeInternal();
        double minX = polyEnvelope.getMinX();
        double maxX = polyEnvelope.getMaxX();
        if (minX >= -180.0 && maxX <= 180.0) {
            return null;
        }
        double offset = -360.0;
        if (minX < -180.0) {
            offset = 360.0;
        }
        Geometry otherSide = g.copy();
        otherSide.apply((CoordinateSequenceFilter)new FilterFunction_offset.OffsetOrdinateFilter(offset, 0.0));
        return (T)otherSide;
    }

    private boolean testDisjoint(PreparedPolygon reference, Geometry test) {
        boolean disjoint = reference.disjoint(test);
        if (!disjoint) {
            return disjoint;
        }
        Geometry otherSide = this.flipDatelineSide(test);
        if (otherSide == null) {
            return true;
        }
        return reference.disjoint(otherSide);
    }

    private boolean testContains(PreparedPolygon reference, Geometry test) {
        boolean contains = reference.contains(test);
        if (contains) {
            return contains;
        }
        Geometry otherSide = this.flipDatelineSide(test);
        if (otherSide == null) {
            return false;
        }
        return reference.contains(otherSide);
    }

    @Override
    public long countZonesFromEnvelope(Envelope envelope, int resolution) {
        Envelope intersection = envelope.intersection((Envelope)WORLD);
        if (intersection.isNull()) {
            return 0L;
        }
        AtomicLong counter = new AtomicLong();
        RHealPixZoneIterator<AtomicLong> iterator = new RHealPixZoneIterator<AtomicLong>(this, zone -> {
            Polygon boundary = zone.getBoundary();
            if (!this.overlaps(boundary, envelope, true)) {
                return false;
            }
            return zone.getResolution() < resolution && !this.contained(boundary, envelope, true);
        }, zone -> {
            int currentResolution = zone.getResolution();
            Polygon boundary = zone.getBoundary();
            if (zone.getResolution() == resolution) {
                if (this.overlaps(boundary, envelope, true)) {
                    counter.addAndGet(1L);
                    return true;
                }
            } else if (this.contained(boundary, envelope, true)) {
                counter.addAndGet(this.childrenCount(resolution - currentResolution));
            }
            return false;
        }, zone -> counter);
        while (iterator.hasNext()) {
            iterator.next();
        }
        return counter.get();
    }

    private long childrenCount(int resolutionDifference) {
        return (long)Math.pow(9.0, resolutionDifference);
    }

    @Override
    public List<AttributeDescriptor> getExtraProperties() {
        ArrayList<AttributeDescriptor> result = new ArrayList<AttributeDescriptor>();
        AttributeTypeBuilder builder = new AttributeTypeBuilder();
        builder.setName("shape");
        builder.setBinding(String.class);
        result.add(builder.buildDescriptor("shape"));
        builder.setName("color");
        builder.setBinding(String.class);
        result.add(builder.buildDescriptor("color"));
        return result;
    }

    @Override
    public Iterator<Zone> neighbors(String id, int radius) {
        HashSet<String> result = new HashSet<String>();
        result.add(id);
        HashSet<String> toExplore = new HashSet<String>();
        toExplore.add(id);
        this.runtime.runSafe(interpreter -> {
            for (int i = 0; i < radius; ++i) {
                HashSet nextRound = new HashSet();
                for (String cell : toExplore) {
                    RHealPixUtils.setCellId(interpreter, "id", cell);
                    List neighbors = ((List)interpreter.getValue("list(Cell(dggs, id).neighbors(False).values())", List.class)).stream().map(o -> String.valueOf(o)).collect(Collectors.toList());
                    ArrayList newZones = new ArrayList(neighbors);
                    newZones.removeAll(result);
                    result.addAll(newZones);
                    nextRound.addAll(newZones);
                }
                toExplore.clear();
                toExplore.addAll(nextRound);
            }
            return null;
        });
        result.remove(id);
        return result.stream().map(zoneId -> new RHealPixZone(this, (String)zoneId)).iterator();
    }

    @Override
    public Iterator<Zone> children(String zoneId, int resolution) {
        RHealPixZone parent = this.getZone(zoneId);
        if (parent.getResolution() >= resolution) {
            return new EmptyIterator();
        }
        return new RHealPixZoneIterator<Zone>(this, zone -> zone.getResolution() < resolution, zone -> zone.getResolution() == resolution, zone -> zone, Arrays.asList(zoneId));
    }

    @Override
    public Iterator<Zone> parents(String id) {
        this.getZone(id);
        return new RHealPixParentIterator(id, this);
    }

    @Override
    public Zone point(Point point, int resolution) {
        return this.runtime.runSafe(interpreter -> {
            interpreter.set("p", Arrays.asList(point.getX(), point.getY()));
            interpreter.set("r", (Object)resolution);
            List idList = (List)interpreter.getValue("dggs.cell_from_point(r, p, False).suid", List.class);
            return new RHealPixZone(this, this.toZoneId(idList));
        });
    }

    @Override
    public Iterator<Zone> polygon(Polygon polygon, int resolution, boolean compact) {
        Envelope envelope = polygon.getEnvelopeInternal();
        Envelope intersection = envelope.intersection((Envelope)WORLD);
        if (intersection.isNull()) {
            return new EmptyIterator();
        }
        PreparedPolygon prepared = new PreparedPolygon((Polygonal)polygon);
        RHealPixZoneIterator<Zone> compactIterator = new RHealPixZoneIterator<Zone>(this, zone -> zone.getResolution() < resolution && !this.testDisjoint(prepared, (Geometry)zone.getBoundary()) && !this.testContains(prepared, (Geometry)zone.getBoundary()), zone -> zone.getResolution() == resolution && this.testContains(prepared, (Geometry)zone.getCenter()) || this.testContains(prepared, (Geometry)zone.getBoundary()), zone -> zone);
        if (compact) {
            return compactIterator;
        }
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(compactIterator, 16), false).flatMap(z -> {
            if (z.getResolution() < resolution) {
                return StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.children(z.getId(), resolution), 16), false);
            }
            return Stream.of(z);
        }).iterator();
    }

    @Override
    public Filter getChildFilter(FilterFactory ff, String zoneId, int resolution, boolean upTo) {
        return ff.like((Expression)ff.property("zoneId"), zoneId + "%", "%", "?", "\\", true);
    }
}

