/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.dggs.rhealpix;

import java.io.IOException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import jep.JepException;
import org.geotools.api.data.Parameter;
import org.geotools.dggs.DGGSFactory;
import org.geotools.dggs.DGGSInstance;
import org.geotools.dggs.rhealpix.JEPRuntime;
import org.geotools.dggs.rhealpix.JEPWebRuntime;
import org.geotools.dggs.rhealpix.RHealPixDGGSInstance;
import org.geotools.util.logging.Logging;

public class RHealPixDGGSFactory
implements DGGSFactory {
    static final Logger LOGGER = Logging.getLogger(RHealPixDGGSFactory.class);
    private static final JEPRuntime.Initializer INITIALIZER = interpreter -> {
        interpreter.exec("from rhealpixdggs import dggs, ellipsoids");
        interpreter.exec("from rhealpixdggs.ellipsoids import Ellipsoid");
        interpreter.exec("from rhealpixdggs.dggs import RHEALPixDGGS, Cell");
        interpreter.exec("WGS84_TB16 = Ellipsoid(a=6378137.0, b=6356752.314140356, e=0.0578063088401, f=0.003352810681182, lon_0=-131.25)");
        interpreter.exec("dggs = RHEALPixDGGS(ellipsoid=WGS84_TB16, north_square=0, south_square=0, N_side=3)");
    };

    @Override
    public String getId() {
        return "rHEALPix";
    }

    @Override
    public Parameter[] getParametersInfo() {
        return new Parameter[0];
    }

    @Override
    public DGGSInstance createInstance(Map<String, ?> params) throws IOException {
        return new RHealPixDGGSInstance(new JEPWebRuntime(INITIALIZER), "rHEALPix");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isAvailable() {
        JEPWebRuntime runtime = new JEPWebRuntime(INITIALIZER);
        boolean interpreterFound = false;
        try {
            runtime.getInterpreter();
            interpreterFound = true;
            boolean bl = true;
            return bl;
        }
        catch (Error | Exception e) {
            LOGGER.log(Level.FINE, "Could not instantiate a rHEALPix DGGS", e);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (interpreterFound) {
                    JEPWebRuntime.closeThreadIntepreter();
                }
            }
            catch (JepException e) {
                LOGGER.log(Level.FINE, "Could not clean up the JEP runtime", e);
            }
        }
    }
}

