/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.dggs.rhealpix;

import java.util.logging.Logger;
import jep.JepException;
import jep.SharedInterpreter;
import org.geotools.dggs.rhealpix.JEPRuntime;
import org.geotools.util.logging.Logging;

public class JEPWebRuntime
implements JEPRuntime {
    static final Logger LOGGER = Logging.getLogger(JEPWebRuntime.class);
    private final JEPRuntime.Initializer initializer;
    static final ThreadLocal<SharedInterpreter> INTERPRETER = new ThreadLocal();

    public JEPWebRuntime(JEPRuntime.Initializer initializer) {
        this.initializer = initializer;
    }

    public void dispose() {
    }

    public static void closeThreadIntepreter() throws JepException {
        SharedInterpreter interpreter = INTERPRETER.get();
        INTERPRETER.remove();
        if (interpreter != null) {
            interpreter.close();
        }
    }

    @Override
    public SharedInterpreter getInterpreter() throws JepException {
        SharedInterpreter interpreter = INTERPRETER.get();
        if (interpreter == null) {
            interpreter = new SharedInterpreter();
            this.initializer.initalize(interpreter);
            INTERPRETER.set(interpreter);
        }
        return interpreter;
    }

    <T> T run(JEPRuntime.InterpreterFunction<T> function, JEPRuntime.ExceptionHandler handler) throws Exception {
        try {
            return function.accept(this.getInterpreter());
        }
        catch (JepException e) {
            Object result = handler.accept(e);
            if (result != null) {
                throw result;
            }
            return null;
        }
    }

    <T> T runSafe(JEPRuntime.InterpreterFunction<T> function, JEPRuntime.RuntimeExceptionHandler handler) {
        try {
            return function.accept(this.getInterpreter());
        }
        catch (JepException e) {
            Object result = handler.accept(e);
            if (result != null) {
                throw result;
            }
            return null;
        }
    }

    <T> T runSafe(JEPRuntime.InterpreterFunction<T> function) {
        try {
            return function.accept(this.getInterpreter());
        }
        catch (JepException e) {
            throw new RuntimeException(e);
        }
    }
}

