/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.dggs.h3;

import com.uber.h3core.H3Core;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Stack;
import java.util.function.Function;

class H3ZoneIterator<R>
implements Iterator<R> {
    private final H3Core h3;
    Function<Long, Boolean> drill;
    Function<Long, Boolean> accept;
    Function<Long, R> map;
    Stack<Long> candidates = new Stack();
    R next = null;

    public H3ZoneIterator(H3Core h3, Function<Long, Boolean> drill, Function<Long, Boolean> accept, Function<Long, R> map) {
        this(h3, drill, accept, map, h3.getRes0Indexes());
    }

    public H3ZoneIterator(H3Core h3, Function<Long, Boolean> drill, Function<Long, Boolean> accept, Function<Long, R> map, Collection<Long> rootZones) {
        this.h3 = h3;
        this.drill = drill;
        this.accept = accept;
        this.map = map;
        this.candidates.addAll(rootZones);
    }

    @Override
    public boolean hasNext() {
        while (this.next == null && !this.candidates.isEmpty()) {
            Long test = this.candidates.pop();
            if (this.accept.apply(test).booleanValue()) {
                this.next = this.map.apply(test);
            }
            if (!this.drill.apply(test).booleanValue()) continue;
            this.candidates.addAll(this.h3.h3ToChildren(test.longValue(), this.h3.h3GetResolution(test.longValue()) + 1));
        }
        return this.next != null;
    }

    @Override
    public R next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        R result = this.next;
        this.next = null;
        return result;
    }
}

