/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.dggs.gstore;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;
import org.geotools.api.data.SimpleFeatureReader;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.AttributeDescriptor;
import org.geotools.dggs.Zone;
import org.geotools.feature.simple.SimpleFeatureBuilder;

class ZonesFeatureIterator
implements SimpleFeatureReader {
    private final Iterator<Zone> iterator;
    private final List<String> requestedProperties;
    SimpleFeatureBuilder fb;
    List<Boolean> includeExtraProperties;

    public ZonesFeatureIterator(Iterator<Zone> iterator, SimpleFeatureType schema, List<AttributeDescriptor> extraProperties) {
        this.iterator = iterator;
        this.fb = new SimpleFeatureBuilder(schema);
        this.requestedProperties = schema.getAttributeDescriptors().stream().map(ad -> ad.getLocalName()).collect(Collectors.toList());
    }

    public SimpleFeatureType getFeatureType() {
        return this.fb.getFeatureType();
    }

    public SimpleFeature next() throws IOException, IllegalArgumentException, NoSuchElementException {
        Zone zone = this.iterator.next();
        String id = zone.getId();
        for (String p : this.requestedProperties) {
            if ("geometry".equals(p)) {
                this.fb.add((Object)zone.getBoundary());
                continue;
            }
            if ("zoneId".equals(p)) {
                this.fb.add((Object)id);
                continue;
            }
            if ("resolution".equals(p)) {
                this.fb.add((Object)zone.getResolution());
                continue;
            }
            this.fb.add(zone.getExtraProperty(p));
        }
        return this.fb.buildFeature(this.fb.getFeatureType().getTypeName() + "." + id);
    }

    public boolean hasNext() throws IOException {
        return this.iterator.hasNext();
    }

    public void close() throws IOException {
    }
}

