/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.dggs;

import com.google.common.collect.Iterators;
import java.util.Iterator;
import java.util.List;
import org.geotools.api.feature.type.AttributeDescriptor;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.dggs.Zone;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;

public interface DGGSInstance
extends AutoCloseable {
    public static final ReferencedEnvelope WORLD = new ReferencedEnvelope(-180.0, 180.0, -90.0, 90.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);

    public String getIdentifier();

    @Override
    public void close();

    public int[] getResolutions();

    public List<AttributeDescriptor> getExtraProperties();

    public Zone getZone(String var1);

    public Zone getZone(double var1, double var3, int var5);

    public Iterator<Zone> zonesFromEnvelope(Envelope var1, int var2, boolean var3);

    default public long countZonesFromEnvelope(Envelope envelope, int resolution) {
        return Iterators.size(this.zonesFromEnvelope(envelope, resolution, false));
    }

    public Iterator<Zone> neighbors(String var1, int var2);

    default public long countNeighbors(String id, int resolution) {
        return Iterators.size(this.neighbors(id, resolution));
    }

    public Iterator<Zone> children(String var1, int var2);

    default public long countChildren(String id, int resolution) {
        return Iterators.size(this.children(id, resolution));
    }

    public Iterator<Zone> parents(String var1);

    default public long countParents(String id) {
        long count = 0L;
        Iterator<Zone> iterator = this.parents(id);
        while (iterator.hasNext()) {
            iterator.next();
            ++count;
        }
        return count;
    }

    public Zone point(Point var1, int var2);

    public Iterator<Zone> polygon(Polygon var1, int var2, boolean var3);

    default public long countPolygon(Polygon polygon, int resolution) {
        return Iterators.size(this.polygon(polygon, resolution, false));
    }

    public Filter getChildFilter(FilterFactory var1, String var2, int var3, boolean var4);
}

