/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.dggs;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Logger;
import java.util.stream.Stream;
import org.geotools.dggs.DGGSFactory;
import org.geotools.dggs.DGGSInstance;
import org.geotools.util.factory.FactoryCreator;
import org.geotools.util.factory.FactoryRegistry;
import org.geotools.util.logging.Logging;

public class DGGSFactoryFinder {
    protected static final Logger LOGGER = Logging.getLogger(DGGSFactoryFinder.class);
    private static volatile FactoryRegistry registry;

    private DGGSFactoryFinder() {
    }

    public static synchronized Stream<DGGSFactory> getExtensionFactories() {
        return DGGSFactoryFinder.getServiceRegistry().getFactories(DGGSFactory.class, null, null).filter(DGGSFactory::isAvailable);
    }

    public static synchronized Optional<DGGSFactory> getFactory(String factoryId) {
        return DGGSFactoryFinder.getExtensionFactories().filter(f -> factoryId.equals(f.getId())).findFirst();
    }

    public static synchronized Stream<String> getFactoryIdentifiers() {
        return DGGSFactoryFinder.getExtensionFactories().map(f -> f.getId());
    }

    private static FactoryRegistry getServiceRegistry() {
        assert (Thread.holdsLock(DGGSFactoryFinder.class));
        if (registry == null) {
            registry = new FactoryCreator(Arrays.asList(DGGSFactory.class));
        }
        return registry;
    }

    public static synchronized void scanForPlugins() {
        DGGSFactoryFinder.getServiceRegistry().scanForPlugins();
    }

    public static DGGSInstance createInstance(String factoryId, Map<String, ?> params) throws IOException {
        if (factoryId == null) {
            throw new IllegalArgumentException("Cannot create a store with a missing factory id");
        }
        DGGSFactory factory = DGGSFactoryFinder.getExtensionFactories().filter(f -> factoryId.equals(f.getId())).findFirst().orElseThrow(() -> new IllegalArgumentException("Cannot find DGGS factory for id " + factoryId));
        return factory.createInstance(params);
    }
}

