/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.dggs.rhealpix;

import com.google.common.collect.Iterators;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import jep.JepException;
import jep.SharedInterpreter;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.dggs.DGGSFactory;
import org.geotools.dggs.DGGSFactoryFinder;
import org.geotools.dggs.DGGSInstance;
import org.geotools.dggs.Zone;
import org.geotools.dggs.rhealpix.JEPWebRuntime;
import org.geotools.dggs.rhealpix.RHealPixUtils;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.util.logging.Logging;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKTReader;

public class RHealPixInstanceTest {
    static final Logger LOGGER = Logging.getLogger(RHealPixInstanceTest.class);
    private static final GeometryFactory GF = new GeometryFactory();
    private static final ReferencedEnvelope WORLD = new ReferencedEnvelope(-180.0, 180.0, -90.0, 90.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
    private DGGSInstance rpix;

    @Before
    public void setup() throws IOException {
        Optional<DGGSFactory> factory = DGGSFactoryFinder.getExtensionFactories().filter(d -> "rHEALPix".equalsIgnoreCase(d.getId())).findFirst();
        Assume.assumeTrue((boolean)factory.isPresent());
        this.rpix = factory.get().createInstance(null);
    }

    @After
    public void cleanup() throws JepException {
        JEPWebRuntime.closeThreadIntepreter();
    }

    @Test
    public void getZone() throws JepException {
        Zone zone = this.rpix.getZone("P");
        Assert.assertNotNull((Object)zone);
        Assert.assertEquals((long)0L, (long)zone.getResolution());
    }

    @Test
    public void zonesFromEnvelopeWorldResZero() {
        Iterator zonesIterator = this.rpix.zonesFromEnvelope((Envelope)WORLD, 0, false);
        HashSet zones = new HashSet();
        zonesIterator.forEachRemaining(zones::add);
        Assert.assertEquals((long)6L, (long)zones.size());
    }

    @Test
    public void zonesFromEnvelopeAcrossDateline() throws IOException {
        Iterator zonesIterator = this.rpix.zonesFromEnvelope((Envelope)new ReferencedEnvelope(-181.0, -179.0, -10.0, 10.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84), 0, false);
        HashSet zones = new HashSet();
        zonesIterator.forEachRemaining(zones::add);
        Assert.assertEquals((long)1L, (long)zones.size());
        Assert.assertEquals((Object)"P", (Object)((Zone)zones.iterator().next()).getId());
    }

    @Test
    public void testZoneAndGeometry() throws IOException, ParseException {
        Zone zone = this.rpix.getZone("N");
        Assert.assertEquals((double)90.0, (double)zone.getCenter().getY(), (double)0.0);
        Polygon polygon = zone.getBoundary();
        Polygon expected = (Polygon)new WKTReader().read("POLYGON ((-180 41.937853904844985, -180 90, 180 90, 180 41.937853904844985, -180 41.937853904844985))");
        Assert.assertTrue((boolean)polygon.equalsExact((Geometry)expected, 1.0E-6));
    }

    @Test
    public void countZonesFromEnvelopeWorldResZero() {
        ReferencedEnvelope envelope = WORLD;
        this.assertZoneCount(envelope, 0);
    }

    @Test
    public void countZonesFromEnvelopeWorldResOne() {
        ReferencedEnvelope envelope = WORLD;
        this.assertZoneCount(envelope, 1);
    }

    @Test
    public void countZonesFromEnvelopeWorldResTwo() {
        ReferencedEnvelope envelope = new ReferencedEnvelope(-1.0, 1.0, -1.0, 1.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        this.assertZoneCount(envelope, 2);
    }

    @Test
    public void countZonesCloseToPole() {
        ReferencedEnvelope envelope = new ReferencedEnvelope(102.0, 103.0, 88.9, 90.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        this.assertZoneCount(envelope, 4);
    }

    @Test
    public void countZonesCloseToDateline() {
        ReferencedEnvelope envelope = new ReferencedEnvelope(175.0, 176.0, 81.4, 81.7, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        this.assertZoneCount(envelope, 1);
    }

    @Test
    @Ignore
    public void testRandomized() {
        Random random = new Random();
        int LOOPS = 1000;
        int MAX_RESOLUTION = 4;
        for (int i = 0; i < 1000; ++i) {
            double lon1 = random.nextDouble() * 360.0 - 180.0;
            double lon2 = lon1 + random.nextDouble() * (180.0 - lon1);
            double lat1 = random.nextDouble() * 180.0 - 90.0;
            double lat2 = lat1 + random.nextDouble() * (90.0 - lat1);
            ReferencedEnvelope envelope = new ReferencedEnvelope(lon1, lon2, lat1, lat2, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
            int resolution = (int)(random.nextDouble() * 4.0);
            try {
                this.assertZoneCount(envelope, resolution);
                continue;
            }
            catch (AssertionError e) {
                LOGGER.severe(envelope + " / " + resolution + " -> " + ((Throwable)((Object)e)).getMessage());
            }
        }
    }

    public void assertZoneCount(ReferencedEnvelope envelope, int resolution) {
        long count = this.rpix.countZonesFromEnvelope((Envelope)envelope, resolution);
        int expected = Iterators.size((Iterator)this.rpix.zonesFromEnvelope((Envelope)envelope, resolution, false));
        ArrayList expectedZones = new ArrayList();
        this.rpix.zonesFromEnvelope((Envelope)envelope, resolution, false).forEachRemaining(z -> expectedZones.add(z.getId()));
        Assert.assertEquals((String)("Expected " + expected + " " + expectedZones + " but got " + count), (long)expected, (long)count);
    }

    @Test
    public void testNeighborsNorthPole() {
        Iterator iterator = this.rpix.neighbors("N4", 1);
        ArrayList neighbors = new ArrayList();
        iterator.forEachRemaining(z -> neighbors.add(z.getId()));
        MatcherAssert.assertThat(neighbors, (Matcher)CoreMatchers.hasItems((Object[])new String[]{"N1", "N3", "N5", "N7"}));
    }

    @Test
    public void testNeighborsDateline() {
        Iterator iterator = this.rpix.neighbors("P3", 1);
        ArrayList neighbors = new ArrayList();
        iterator.forEachRemaining(z -> neighbors.add(z.getId()));
        MatcherAssert.assertThat(neighbors, (Matcher)CoreMatchers.hasItems((Object[])new String[]{"P0", "O5", "P6", "P4"}));
        MatcherAssert.assertThat(neighbors, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.hasItems((Object[])new String[]{"P3"})));
        Assert.assertEquals((long)4L, (long)neighbors.size());
    }

    @Test
    public void testNeighborsDatelineRadius2() {
        Iterator iterator = this.rpix.neighbors("P3", 2);
        ArrayList neighbors = new ArrayList();
        iterator.forEachRemaining(z -> neighbors.add(z.getId()));
        MatcherAssert.assertThat(neighbors, (Matcher)CoreMatchers.hasItems((Object[])new String[]{"P0", "O2", "O5", "O8", "P6", "P1", "P4", "P7", "O4", "N8", "P5", "S2"}));
        MatcherAssert.assertThat(neighbors, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.hasItems((Object[])new String[]{"P3"})));
        Assert.assertEquals((long)12L, (long)neighbors.size());
    }

    @Test
    public void testNeighborsAll() {
        Iterator iterator = this.rpix.neighbors("R3", 10);
        ArrayList neighbors = new ArrayList();
        iterator.forEachRemaining(z -> neighbors.add(z.getId()));
        Iterator zonesIterator = this.rpix.zonesFromEnvelope((Envelope)WORLD, 1, false);
        HashSet expected = new HashSet();
        zonesIterator.forEachRemaining(z -> expected.add(z.getId()));
        expected.remove("R3");
        Assert.assertEquals((long)expected.size(), (long)neighbors.size());
        Assert.assertTrue((boolean)expected.containsAll(neighbors));
    }

    @Test
    public void testChildren() throws Exception {
        String parent = "R";
        SharedInterpreter interpreter = (SharedInterpreter)JEPWebRuntime.INTERPRETER.get();
        for (int r = 1; r < 4; ++r) {
            HashSet actual = new HashSet();
            this.rpix.children(parent, r).forEachRemaining(z -> actual.add(z.getId()));
            RHealPixUtils.setCellId((SharedInterpreter)interpreter, (String)"id", (String)parent);
            interpreter.exec("c = Cell(dggs, id)");
            interpreter.set("resolution", (Object)r);
            Set expected = ((List)interpreter.getValue("list(c.subcells(resolution))", List.class)).stream().map(Object::toString).collect(Collectors.toSet());
            Assert.assertEquals(expected, actual);
        }
    }

    @Test
    public void testMapPoint() throws Exception {
        Point northPole = GF.createPoint(new Coordinate(0.0, 90.0));
        String[] expectedIds = new String[]{"N", "N4", "N44"};
        for (int r = 0; r < expectedIds.length; ++r) {
            Zone zone = this.rpix.point(northPole, r);
            Assert.assertEquals((Object)expectedIds[r], (Object)zone.getId());
        }
    }

    @Test
    public void testMapPolygon() throws Exception {
        Polygon polygon = (Polygon)new WKTReader().read("POLYGON((-1 -1, -1 1, 1 1, 1 -1, -1 -1))");
        HashSet actual = new HashSet();
        this.rpix.polygon(polygon, 4, false).forEachRemaining(z -> actual.add(z.getId()));
        HashSet<String> expected = new HashSet<String>(Arrays.asList("R4430", "R4434", "R4433", "R4431", "R4437", "R4436"));
        Assert.assertEquals(expected, actual);
    }

    @Test
    public void zonesFromEnvelopeCompact() throws IOException {
        Iterator zonesIterator = this.rpix.zonesFromEnvelope((Envelope)new ReferencedEnvelope(-20.0, 21.0, -13.2, 21.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84), 2, true);
        TreeSet actual = new TreeSet();
        zonesIterator.forEachRemaining(z -> actual.add(z.getId()));
        Assert.assertEquals((long)17L, (long)actual.size());
        HashSet<String> expected = new HashSet<String>(Arrays.asList("R4", "R08", "R16", "R17", "R18", "R26", "R32", "R35", "R38", "R50", "R53", "R56", "R62", "R70", "R71", "R72", "R80"));
        Assert.assertEquals(expected, actual);
    }
}

