/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.dggs.h3;

import com.uber.h3core.H3Core;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.Function;
import org.geotools.dggs.h3.H3ZoneIterator;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class H3ZoneIteratorTest {
    H3Core h3;

    @Before
    public void createH3() throws IOException {
        this.h3 = H3Core.newInstance();
    }

    private List<Long> collectZones(H3ZoneIterator<Long> iterator) {
        ArrayList<Long> zoneIds = new ArrayList<Long>();
        iterator.forEachRemaining(id -> zoneIds.add((Long)id));
        return zoneIds;
    }

    @Test
    public void testRootZones() {
        H3ZoneIterator iterator = new H3ZoneIterator(this.h3, id -> false, id -> true, Function.identity());
        List<Long> zoneIds = this.collectZones((H3ZoneIterator<Long>)iterator);
        Assert.assertEquals((long)122L, (long)zoneIds.size());
        Assert.assertTrue((boolean)zoneIds.containsAll(this.h3.getRes0Indexes()));
    }

    @Test(expected=NoSuchElementException.class)
    public void testEmpty() {
        H3ZoneIterator iterator = new H3ZoneIterator(this.h3, id -> false, id -> false, Function.identity());
        Assert.assertFalse((boolean)iterator.hasNext());
        iterator.next();
    }

    @Test
    public void testDrillDown() {
        long center = this.h3.geoToH3(0.0, 0.0, 0);
        H3ZoneIterator iterator = new H3ZoneIterator(this.h3, id1 -> this.h3.h3GetResolution(id1.longValue()) < 2, id -> this.h3.h3GetResolution(id.longValue()) == 2, id -> id, Arrays.asList(center));
        List<Long> zones = this.collectZones((H3ZoneIterator<Long>)iterator);
        List l3Children = this.h3.h3ToChildren(center, 2);
        Assert.assertEquals((long)l3Children.size(), (long)zones.size());
        Assert.assertTrue((boolean)zones.containsAll(l3Children));
    }
}

