/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.dggs.h3;

import com.uber.h3core.H3Core;
import java.io.IOException;
import org.geotools.dggs.h3.H3Index;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class H3IndexTest {
    H3Core h3;

    @Before
    public void setup() throws IOException {
        this.h3 = H3Core.newInstance();
    }

    @Test
    public void testGetResolution() {
        long id = this.h3.stringToH3("8075fffffffffff");
        int r = this.h3.h3GetResolution(id);
        while (true) {
            Assert.assertEquals((long)r, (long)new H3Index(id).getResolution());
            if (++r > 15) break;
            id = (Long)this.h3.h3ToChildren(id, r).get(0);
        }
    }

    @Test
    public void testGetLowestIdChildren() throws Exception {
        long id = this.h3.stringToH3("8075fffffffffff");
        long lowestId = new H3Index(id).lowestIdChild(15);
        long childId = id;
        for (int r = 1; r <= 15; ++r) {
            childId = (Long)this.h3.h3ToChildren(childId, r).get(0);
        }
        Assert.assertEquals((String)(Long.toBinaryString(childId) + "\n" + Long.toBinaryString(lowestId)), (long)childId, (long)lowestId);
    }
}

