/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.dggs.gstore;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.geotools.api.data.Query;
import org.geotools.dggs.DGGSInstance;
import org.geotools.dggs.gstore.DGGSResolutionCalculator;
import org.geotools.dggs.h3.H3DGGSFactory;
import org.geotools.filter.function.EnvFunction;
import org.geotools.util.NumberRange;
import org.geotools.util.factory.Hints;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DGGSResolutionCalculatorTest {
    private DGGSInstance dggsInstance;
    private DGGSResolutionCalculator calculator;

    @Before
    public void setUp() throws IOException {
        this.dggsInstance = new H3DGGSFactory().createInstance(new HashMap());
        this.calculator = new DGGSResolutionCalculator(this.dggsInstance);
    }

    @Test
    public void testConstructor() {
        Assert.assertNotNull((Object)this.calculator);
        Assert.assertEquals((long)16L, (long)this.calculator.levelThresholds.length);
    }

    @Test
    public void testIsValid() {
        for (int level = 0; level < 16; ++level) {
            Assert.assertTrue((boolean)this.calculator.isValid(level));
        }
        Assert.assertFalse((boolean)this.calculator.isValid(16));
    }

    @Test
    public void testGetValidResolutions() {
        NumberRange range = this.calculator.getValidResolutions();
        Assert.assertEquals((long)0L, (long)((int)range.getMinimum()));
        Assert.assertEquals((long)15L, (long)((int)range.getMaximum()));
    }

    @Test
    public void testGetTargetResolutionDistanceLarge() {
        Query query = new Query("testLayer");
        Hints hints = new Hints();
        hints.put((Object)Hints.GEOMETRY_DISTANCE, (Object)10.0);
        query.setHints(hints);
        int resolution = this.calculator.getTargetResolution(query, 1);
        Assert.assertEquals((long)0L, (long)resolution);
    }

    @Test
    public void testGetResolutionMin() {
        Query query = new Query("testLayer");
        Hints hints = new Hints();
        hints.put((Object)Hints.GEOMETRY_DISTANCE, (Object)10.0);
        hints.put((Object)DGGSResolutionCalculator.MINRES_HINTS_KEY, (Object)5);
        query.setHints(hints);
        int resolution = this.calculator.getTargetResolution(query, 1);
        Assert.assertEquals((long)5L, (long)resolution);
    }

    @Test
    public void testGetResolutionMinString() {
        Query query = new Query("testLayer");
        Hints hints = new Hints();
        hints.put((Object)Hints.GEOMETRY_DISTANCE, (Object)10.0);
        hints.put((Object)DGGSResolutionCalculator.MINRES_HINTS_KEY, (Object)String.valueOf("5"));
        query.setHints(hints);
        int resolution = this.calculator.getTargetResolution(query, 1);
        Assert.assertEquals((long)5L, (long)resolution);
    }

    @Test
    public void testGetTargetResolutionDistanceSmall() {
        Query query = new Query("testLayer");
        Hints hints = new Hints();
        hints.put((Object)Hints.GEOMETRY_DISTANCE, (Object)0.001);
        query.setHints(hints);
        int resolution = this.calculator.getTargetResolution(query, 1);
        Assert.assertEquals((long)5L, (long)resolution);
    }

    @Test
    public void testGetResolutionMax() {
        Query query = new Query("testLayer");
        Hints hints = new Hints();
        hints.put((Object)Hints.GEOMETRY_DISTANCE, (Object)0.001);
        hints.put((Object)DGGSResolutionCalculator.MAXRES_HINTS_KEY, (Object)2);
        query.setHints(hints);
        int resolution = this.calculator.getTargetResolution(query, 1);
        Assert.assertEquals((long)2L, (long)resolution);
    }

    @Test
    public void testGetResolutionMaxString() {
        Query query = new Query("testLayer");
        Hints hints = new Hints();
        hints.put((Object)Hints.GEOMETRY_DISTANCE, (Object)0.001);
        hints.put((Object)DGGSResolutionCalculator.MAXRES_HINTS_KEY, (Object)String.valueOf(2));
        query.setHints(hints);
        int resolution = this.calculator.getTargetResolution(query, 1);
        Assert.assertEquals((long)2L, (long)resolution);
    }

    @Test
    public void testGetTargetResolutionDistanceOffset() {
        Query query = new Query("testLayer");
        Hints hints = new Hints();
        hints.put((Object)Hints.GEOMETRY_DISTANCE, (Object)10.0);
        hints.put((Object)DGGSResolutionCalculator.OFFSET_HINTS_KEY, (Object)1);
        query.setHints(hints);
        int resolution = this.calculator.getTargetResolution(query, 1);
        Assert.assertEquals((long)1L, (long)resolution);
    }

    @Test
    public void testGetTargetResolutionDistanceOffsetString() {
        Query query = new Query("testLayer");
        Hints hints = new Hints();
        hints.put((Object)Hints.GEOMETRY_DISTANCE, (Object)10.0);
        hints.put((Object)DGGSResolutionCalculator.OFFSET_HINTS_KEY, (Object)String.valueOf("1"));
        query.setHints(hints);
        int resolution = this.calculator.getTargetResolution(query, 1);
        Assert.assertEquals((long)1L, (long)resolution);
    }

    @Test
    public void testGetTargetResolutionString() {
        Query query = new Query("testLayer");
        Hints hints = new Hints();
        hints.put((Object)Hints.VIRTUAL_TABLE_PARAMETERS, Map.of("res", String.valueOf(5)));
        query.setHints(hints);
        int resolution = this.calculator.getTargetResolution(query, 1);
        Assert.assertEquals((long)5L, (long)resolution);
    }

    @Test
    public void testGetTargetResolutionWMSScale() {
        EnvFunction.setLocalValues(Map.of("WMS_SCALE_DENOMINATOR", 10000000));
        try {
            Query query = new Query("testLayer");
            int resolution = this.calculator.getTargetResolution(query, 1);
            Assert.assertEquals((long)2L, (long)resolution);
        }
        finally {
            EnvFunction.clearLocalValues();
        }
    }

    @Test
    public void testGetTargetResolutionWMSScaleString() {
        EnvFunction.setLocalValues(Map.of("WMS_SCALE_DENOMINATOR", String.valueOf(10000000)));
        try {
            Query query = new Query("testLayer");
            int resolution = this.calculator.getTargetResolution(query, 1);
            Assert.assertEquals((long)2L, (long)resolution);
        }
        finally {
            EnvFunction.clearLocalValues();
        }
    }
}

