/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.dggs;

import com.uber.h3core.H3Core;
import org.geotools.api.filter.And;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.FilterVisitor;
import org.geotools.api.filter.PropertyIsEqualTo;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.spatial.Intersects;
import org.geotools.dggs.DGGSFilterTransformer;
import org.geotools.dggs.DGGSInstance;
import org.geotools.dggs.gstore.DGGSResolutionCalculator;
import org.geotools.dggs.h3.H3DGGSInstance;
import org.geotools.factory.CommonFactoryFinder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKTReader;

public class DGGSFilterTransformerTest {
    FilterFactory FF = CommonFactoryFinder.getFilterFactory();
    DGGSFilterTransformer transformer;

    @Before
    public void setupTransformer() throws Exception {
        H3DGGSInstance dggs = new H3DGGSInstance(H3Core.newInstance());
        DGGSResolutionCalculator resolutionCalculator = new DGGSResolutionCalculator((DGGSInstance)dggs);
        this.transformer = new DGGSFilterTransformer((DGGSInstance)dggs, resolutionCalculator, 3);
    }

    @Test
    public void testPolygon() throws Exception {
        Intersects intersects = this.FF.intersects("geom", DGGSFilterTransformerTest.read("POLYGON((12 45, 12 46, 13 46, 13 45, 12 45))"));
        Filter transformed = (Filter)intersects.accept((FilterVisitor)this.transformer, null);
        PropertyIsEqualTo inZone = this.FF.equal((Expression)this.FF.function("in", new Expression[]{this.FF.property("zoneId"), this.FF.literal((Object)"831ea5fffffffff")}), (Expression)this.FF.literal(true), true);
        PropertyIsEqualTo matchResolution = this.FF.equal((Expression)this.FF.property("resolution"), (Expression)this.FF.literal(3), true);
        And expected = this.FF.and((Filter)inZone, (Filter)matchResolution);
        Assert.assertEquals((Object)expected, (Object)transformed);
    }

    @Test
    public void testMultiPolygon() throws Exception {
        Intersects intersects = this.FF.intersects("geom", DGGSFilterTransformerTest.read("MULTIPOLYGON(((11 45, 11 46, 12 46, 12 45, 11 45)), ((12 45, 12 46, 13 46, 13 45, 12 45)))"));
        Filter transformed = (Filter)intersects.accept((FilterVisitor)this.transformer, null);
        PropertyIsEqualTo inZone = this.FF.equal((Expression)this.FF.function("in", new Expression[]{this.FF.property("zoneId"), this.FF.literal((Object)"831ea4fffffffff"), this.FF.literal((Object)"831ea5fffffffff")}), (Expression)this.FF.literal(true), true);
        PropertyIsEqualTo matchResolution = this.FF.equal((Expression)this.FF.property("resolution"), (Expression)this.FF.literal(3), true);
        And expected = this.FF.and((Filter)inZone, (Filter)matchResolution);
        Assert.assertEquals((Object)transformed, (Object)expected);
    }

    private static Geometry read(String wellKnownText) throws ParseException {
        return new WKTReader().read(wellKnownText);
    }
}

